﻿// -----------------------------------------------------------------------
// <copyright file="EntityIdentifier.cs" company="NEHTA">
// Developed by Chamonix for NEHTA.
// </copyright>
// -----------------------------------------------------------------------

using System;
using System.Runtime.Serialization;

namespace HIPS.PcehrSchemas
{
    /// <summary>
    /// Represents an identifier of a person or organisation.
    /// </summary>
    [DataContract]
    public class EntityIdentifier
    {
        /// <summary>
        /// This property is the qualified identifier form. One use of this is
        /// that HIPS will write it as q1:personId element in the eSignature in
        /// CDA_SIGN.XML, where q1 is
        /// "http://ns.electronichealth.net.au/cdaPackage/xsd/eSignature/2012".</para>
        ///
        /// <para>If the identifier is an HPI-I, the URI is built from the
        /// qualifier "http://ns.electronichealth.net.au/id/hi/hpii/1.0/",
        /// followed by the HPI-I number itself.</para>
        ///
        /// <para>If the identifier is a local user identifier, the URI is built from
        /// the qualifier "http://OrgDomainName/id/cda/userid/1.0/", where
        /// OrgDomainName is the domain namespace of the organisation where the
        /// userid came from, followed by the local identifier itself.</para>
        /// </summary>
        [DataMember]
        public Uri QualifiedIdentifier { get; set; }

        /// <summary>
        /// <para>This property is populated from the root attribute of the
        /// ext:asIdentifier/ext:id element in the CDA_ROOT.XML file, where
        /// ext is "http://ns.electronichealth.net.au/Ci/Cda/Extensions/3.0".</para>
        ///
        /// <para>If the identifier is an HPI-I, this property is the OID form of the
        /// HPI-I, which is formed from the OID "1.2.36.1.2001.1003.0"
        /// followed by a dot and the 16-digit HPI-I number.</para>
        ///
        /// <para>If the identifier is a local identifier, this property is an OID
        /// that scopes the identifier. NEHTA have registered an OID prefix a
        /// default option; if the organisation has some other OID to use to
        /// identify the Local System Identifier, then that OID should be used
        /// instead. The NEHTA default OID is "1.2.36.1.2001.1005.41" which
        /// must be followed by a dot and then the HPI-O of the assigning
        /// organisation.</para>
        /// </summary>
        [DataMember]
        public string Root { get; set; }

        /// <summary>
        /// <para>This property is populated from the extension attribute of the
        /// ext:asIdentifier/ext:id element in the CDA_ROOT.XML file, where
        /// ext is "http://ns.electronichealth.net.au/Ci/Cda/Extensions/3.0".</para>
        ///
        /// <para>If the identifier is an HPI-I, this is null.</para>
        ///
        /// <para>If the identifier is a local identifier, this is the local identifier itself.</para>
        /// </summary>
        [DataMember]
        public string Extension { get; set; }

        /// <summary>
        /// <para>This property is populated from the assigningAuthorityName attribute
        /// of the ext:asIdentifier/ext:id element in the CDA_ROOT.XML file, where
        /// ext is "http://ns.electronichealth.net.au/Ci/Cda/Extensions/3.0".</para>
        ///
        /// <para>If the identifier is an HPI-I, the value should be "HPI-I".</para>
        ///
        /// <para>If the identifier is a local identifier, the value should be
        /// a short string that is understandable to an end-user, because it
        /// appears on the rendered CDA document in the square brackets before
        /// the identifier itself. Examples could be "OACIS" or "HAD".</para>
        /// </summary>
        [DataMember]
        public string AssigningAuthorityName { get; set; }
    }
}