﻿namespace HIPS.PcehrSchemas
{
    /// <summary>
    /// Mapping to the public fields exposed from the CodedValueAttribute Attribute extension (Nehta.VendorLibrary.PCEHR.CodedValueAttribute) used for all codes enums
    /// </summary>
    public enum CodedValueAttributeField
    {
        CodingSystem,
        CodingSystemOID,
        ConceptCode,
        ConceptName,
        AlternateName
    }

    /// <summary>
    /// This Enum is used for returning the status of the request to gain acccess.
    /// </summary>
    public enum GainPcehrAccessStatus
    {
        Permit,
        Deny
    }

    /// <summary>
    /// Classification of the action required in response to a PCEHR system message.
    /// </summary>
    public enum FaultAction
    {
        /// <summary>
        /// The action was completed normally. No further action is required.
        /// </summary>
        Completed,

        /// <summary>
        /// The action was completed but there was an issue that should be
        /// investigated and corrected when sufficient resources are available.
        /// </summary>
        CompletedWithWarnings,

        /// <summary>
        /// The remote system encountered an unexpected situation and was unable
        /// to process the message. It is likely that trying the same message
        /// again will result in successful processing. For operations in which
        /// a queue is involved, the message may be pushed back onto the queue.
        /// </summary>
        TransientFailure,

        /// <summary>
        /// The message was badly formed and could not be processed. Trying the
        /// same message again is unlikely to result in successful processing.
        /// The error must be investigated and the contents or configuration
        /// corrected before trying again.
        /// </summary>
        PermanentFailure,

        /// <summary>
        /// An unexpected service message was returned. This should be investigated
        /// similarly to when a permanent failure occurs.
        /// </summary>
        Unknown
    }
}