﻿using System;
using System.Runtime.Serialization;
using HIPS.CommonSchemas;
using HIPS.PcehrDataStore.Schemas.Enumerators;

namespace HIPS.PcehrSchemas
{
    [KnownType(typeof(GainPcehrAccessResponse))]
    [Serializable]
    [DataContract]
    public class GainPcehrAccessResponse
    {
        #region Private Members

        private HipsResponse hipsResponse = new HipsResponse(HipsResponseIndicator.SystemError, null);
        private String ihiNumber = null;
        private GainPcehrAccessStatus accessPermission = GainPcehrAccessStatus.Deny;
        private IhiRecordStatus ihiRecordStatus = IhiRecordStatus.Unknown;
        private IhiStatus ihiStatus = IhiStatus.Unknown;

        #endregion Private Members

        #region Properties

        /// <summary>
        /// Gets or Sets the MyProperty
        /// </summary>
        /// <value>
        /// The myVar
        /// </value>
        [DataMember]
        public HipsResponse HipsResponse
        {
            get { return hipsResponse; }
            set { hipsResponse = value; }
        }

        /// <summary>
        /// Gets or Sets the IHINumber
        /// </summary>
        /// <value>
        /// The ihiNumber
        /// </value>
        [DataMember]
        public String IHINumber
        {
            get { return ihiNumber; }
            set { ihiNumber = value; }
        }

        /// <summary>
        /// Gets or Sets the AccessPermission
        /// </summary>
        /// <value>
        /// The accessPermission
        /// </value>
        [DataMember]
        public GainPcehrAccessStatus AccessPermission
        {
            get { return accessPermission; }
            set { accessPermission = value; }
        }

        /// <summary>
        /// Gets or Sets the IhiRecordStatus
        /// </summary>
        /// <value>
        /// The ihiRecordStatus
        /// </value>
        [DataMember]
        public IhiRecordStatus IhiRecordStatus
        {
            get { return ihiRecordStatus; }
            set { ihiRecordStatus = value; }
        }

        /// <summary>
        /// Gets or Sets the IhiStatus
        /// </summary>
        /// <value>
        /// The ihiStatus
        /// </value>
        [DataMember]
        public IhiStatus IhiStatus
        {
            get { return ihiStatus; }
            set { ihiStatus = value; }
        }

        #endregion Properties
    }
}