﻿using System;
using System.Runtime.Serialization;

namespace HIPS.PcehrSchemas
{
    /// <summary>
    /// This object is used for individual message queue items populated from the PcehrMessageQueue and related tables
    /// </summary>

    [KnownType(typeof(MessageQueueItem))]
    [Serializable]
    [DataContract]
    public class MessageQueueItem
    {
        #region Properties

        private int pcehrMessageQueueId;
        private DateTime queueItemDateCreated;
        private int queueOperationId;
        private string queueOperationName;
        private int queueStatusId;
        private string queueStatusName;
        private int facilityId;
        private string facilityName;
        private int patientId;
        private string ihi;
        private int episodeId;
        private DateTime admissionDateTime;
        private string sourceSystemSetId;
        private Int64 requestSize;
        private Int64 cdaPackageSize;
        private int? documentTypeId;
        private string documentTypeDescription;
        private string documentTypeCode;
        private string documentFormatDescription;
        private string documentFormatCode;
        private string details;

        #endregion Properties

        #region Private Members

        /// <summary>
        /// Gets or Sets the PcehrMessageQueueId
        /// The ID of the PcehrMessageQueue table
        /// </summary>
        /// <value>
        /// The pcehrMessageQueueId
        /// </value>
        [DataMember]
        public int PcehrMessageQueueId
        {
            get { return pcehrMessageQueueId; }
            set { pcehrMessageQueueId = value; }
        }

        /// <summary>
        /// Gets or Sets the QueueItemDateCreated
        /// The Date and time that the item was created
        /// </summary>
        /// <value>
        /// The queueItemDateCreated
        /// </value>
        [DataMember]
        public DateTime QueueItemDateCreated
        {
            get { return queueItemDateCreated; }
            set { queueItemDateCreated = value; }
        }

        /// <summary>
        /// Gets or Sets the QueueOperationId
        /// The ID of the Operation Name - 1 Upload or Supersede, 2 = Remove
        /// </summary>
        /// <value>
        /// The queueOperationId
        /// </value>
        [DataMember]
        public int QueueOperationId
        {
            get { return queueOperationId; }
            set { queueOperationId = value; }
        }

        /// <summary>
        /// Gets or Sets the QueueOperationName
        /// The readable name of the operation
        /// </summary>
        /// <value>
        /// The queueOperationName
        /// </value>
        [DataMember]
        public string QueueOperationName
        {
            get { return queueOperationName; }
            set { queueOperationName = value; }
        }

        /// <summary>
        /// Gets or Sets the QueueStatusId
        /// The ID of the queue status Pending = 1, Success = 2, Failure = 3
        /// </summary>
        /// <value>
        /// The queueStatusId
        /// </value>
        [DataMember]
        public int QueueStatusId
        {
            get { return queueStatusId; }
            set { queueStatusId = value; }
        }

        /// <summary>
        /// Gets or Sets the QueueStatusName
        /// The readable name of the Queue Status
        /// </summary>
        /// <value>
        /// The queueStatusName
        /// </value>
        [DataMember]
        public string QueueStatusName
        {
            get { return queueStatusName; }
            set { queueStatusName = value; }
        }

        /// <summary>
        /// Gets or Sets the FacilityId
        /// The Database ID of the facility/hospital name
        /// </summary>
        /// <value>
        /// The facilityId
        /// </value>
        [DataMember]
        public int FacilityId
        {
            get { return facilityId; }
            set { facilityId = value; }
        }

        /// <summary>
        /// Gets or Sets the FacilityName
        /// The Readable name of the Facility/Hospital
        /// </summary>
        /// <value>
        /// The facilityName
        /// </value>
        [DataMember]
        public string FacilityName
        {
            get { return facilityName; }
            set { facilityName = value; }
        }

        /// <summary>
        /// Gets or Sets the PatientId
        /// The database id of the HospitalPatientId for the patient
        /// </summary>
        /// <value>
        /// The patientId
        /// </value>
        [DataMember]
        public int PatientId
        {
            get { return patientId; }
            set { patientId = value; }
        }

        /// <summary>
        /// Gets or Sets the IHI
        /// The IHI of the patient
        /// </summary>
        /// <value>
        /// The ihi
        /// </value>
        [DataMember]
        public string IHI
        {
            get { return ihi; }
            set { ihi = value; }
        }

        /// <summary>
        /// Gets or Sets the EpisodeId
        /// The database id of the episode - which could be a stub, if no actual admission
        /// </summary>
        /// <value>
        /// The episodeId
        /// </value>
        [DataMember]
        public int EpisodeId
        {
            get { return episodeId; }
            set { episodeId = value; }
        }

        /// <summary>
        /// Gets or Sets the AdmissionDateTime
        /// Admission Date of the Episode - if applicable as it may be related to a stub
        /// </summary>
        /// <value>
        /// The admissionDateTime
        /// </value>
        [DataMember]
        public DateTime AdmissionDateTime
        {
            get { return admissionDateTime; }
            set { admissionDateTime = value; }
        }

        /// <summary>
        /// Gets or Sets the SourceSystemSetId
        /// The SourceSystemSetId of the operation
        /// </summary>
        /// <value>
        /// The string sourceSystemSetId
        /// </value>
        [DataMember]
        public string SourceSystemSetId
        {
            get { return sourceSystemSetId; }
            set { sourceSystemSetId = value; }
        }

        /// <summary>
        /// Gets or Sets the RequestSize
        /// The size (in bytes) of the SOAP request - this is only populated if the queued operation has failed
        /// </summary>
        /// <value>
        /// The RequestSize
        /// </value>
        [DataMember]
        public Int64 RequestSize
        {
            get { return requestSize; }
            set { requestSize = value; }
        }

        /// <summary>
        /// Gets or Sets the CDAPackageSize
        /// The byte size of the CDA package (ZIP file) that is to be uploaded to the PCEHR system
        /// </summary>
        /// <value>
        /// The cdaPackageSize
        /// </value>
        [DataMember]
        public Int64 CDAPackageSize
        {
            get { return cdaPackageSize; }
            set { cdaPackageSize = value; }
        }

        /// <summary>
        /// Gets or Sets the DocumentTypeId
        /// The Database id of the DocumentType determined using the <code> element in the CDA document
        /// </summary>
        /// <value>
        /// The documentTypeId
        /// </value>
        [DataMember]
        public int? DocumentTypeId
        {
            get { return documentTypeId; }
            set { documentTypeId = value; }
        }

        /// <summary>
        /// Gets or Sets the DocumentTypeDescription
        /// The description of the document type, from the DocumentType reference table.
        /// </summary>
        /// <value>
        /// The documentTypeDescription
        /// </value>
        [DataMember]
        public string DocumentTypeDescription
        {
            get { return documentTypeDescription; }
            set { documentTypeDescription = value; }
        }

        /// <summary>
        /// Gets or Sets the DocumentTypeCode
        /// The code for the document type, from the DocumentType reference table.
        /// </summary>
        /// <value>
        /// The documentTypeCode
        /// </value>
        [DataMember]
        public string DocumentTypeCode
        {
            get { return documentTypeCode; }
            set { documentTypeCode = value; }
        }

        /// <summary>
        /// Gets or Sets the DocumentFormatDescription
        /// </summary>
        /// <value>
        /// The documentFormatDescription
        /// </value>
        [DataMember]
        public string DocumentFormatDescription
        {
            get { return documentFormatDescription; }
            set { documentFormatDescription = value; }
        }

        /// <summary>
        /// Gets or Sets the DocumentFormatCode
        /// </summary>
        /// <value>
        /// The documentFormatCode
        /// </value>
        [DataMember]
        public string DocumentFormatCode
        {
            get { return documentFormatCode; }
            set { documentFormatCode = value; }
        }

        /// <summary>
        /// Gets or Sets the Details
        /// Details of the error that occurred. This is only populated if the queued operation has failed.
        /// </summary>
        /// <value>
        /// The details
        /// </value>
        [DataMember]
        public string Details
        {
            get { return details; }
            set { details = value; }
        }

        /// <summary>
        /// Gets or sets the serialised object.
        /// </summary>
        /// <value>
        /// The serialised object.
        /// </value>
        // This is NOT a DataMember as it is NOT to be passed back across a Web Service call
        public byte[] SerialisedObject { get; set; }

        #endregion Private Members

        #region Properties

        #endregion Properties

    }
}