﻿// -----------------------------------------------------------------------
// <copyright file="OperationStatus.cs" company="NEHTA">
// Developed by Chamonix for NEHTA.
// </copyright>
// -----------------------------------------------------------------------

using System.Collections.Generic;
using HIPS.CommonSchemas;
using HIPS.PcehrDataStore.Schemas;

namespace HIPS.PcehrSchemas
{
    /// <summary>
    /// The result of an operation status query.
    /// </summary>
    public class OperationStatus
    {
        private HipsResponse response = new HipsResponse(HipsResponseIndicator.OK);
        private List<PcehrMessageQueue> queuedOperations = new List<PcehrMessageQueue>();
        private List<ClinicalDocument> uploadedDocuments = new List<ClinicalDocument>();
        private List<ClinicalDocumentVersion> uploadedDocumentVersions = new List<ClinicalDocumentVersion>();

        public List<PcehrMessageQueue> QueuedOperations
        {
            get
            {
                return queuedOperations;
            }
            set
            {
                queuedOperations = value;
            }
        }

        public List<ClinicalDocument> UploadedDocuments
        {
            get
            {
                return uploadedDocuments;
            }
            set
            {
                uploadedDocuments = value;
            }
        }

        public List<ClinicalDocumentVersion> UploadedDocumentVersions
        {
            get
            {
                return uploadedDocumentVersions;
            }
            set
            {
                uploadedDocumentVersions = value;
            }
        }

        public HipsResponse Response
        {
            get
            {
                return response;
            }
            set
            {
                response = value;
            }
        }
    }
}