﻿using System;
using System.Collections.Generic;
using System.Runtime.Serialization;
using HIPS.CommonSchemas;
using HIPS.CommonSchemas.PatientIdentifier;
using HIPS.PcehrDataStore.Schemas;

namespace HIPS.PcehrSchemas
{
    /// <summary>
    /// This object is used for the package response from the “PatientWithoutPcehr” methods.
    /// </summary>
    [Serializable]
    [DataContract(Name = "PatientWithoutPcehrResponse")]
    public class PatientWithoutPcehrResponse
    {
        #region Private Members

        private HipsResponse hipsResponse = new HipsResponse(HipsResponseIndicator.SystemError, null);
        private IList<PatientWithoutPcehr> patientWithoutPcehrList = new List<PatientWithoutPcehr>();

        #endregion Private Members

        #region Properties

        /// <summary>
        /// Gets or Sets the HipsResponse.
        /// Common Response Object.
        /// </summary>
        /// <value>
        /// The hipsResponse
        /// </value>
        [DataMember]
        public HipsResponse HipsResponse
        {
            get { return hipsResponse; }
            set { hipsResponse = value; }
        }

        /// <summary>
        /// Gets or Sets the DocumentList IList.
        /// List of the Document Meta Data Items.
        /// </summary>
        /// <value>
        /// The DocumentList
        /// </value>
        [DataMember]
        public IList<PatientWithoutPcehr> PatientWithoutPcehrList
        {
            get { return patientWithoutPcehrList; }
            set { patientWithoutPcehrList = value; }
        }

        #endregion Properties
    }
}