﻿using System;
using System.Collections.Generic;
using System.Runtime.Serialization;
using HIPS.CommonSchemas;
using HIPS.CommonSchemas.PatientIdentifier;
using HIPS.PcehrDataStore.Schemas;

namespace HIPS.PcehrSchemas
{
    /// <summary>
    /// This object is used for the package response from the “Patient Registration” methods.
    /// </summary>
    [Serializable]
    [DataContract(Name = "PcehrRegistrationResponse")]
    public class PcehrRegistrationResponse
    {
        #region Private Members

        private HipsResponse hipsResponse = new HipsResponse(HipsResponseIndicator.SystemError, null);
        private string ivcCode = string.Empty;
        private DateTime ivcExpiryDate = DateTime.MinValue;
        private int patientMasterId;

        #endregion Private Members

        #region Properties

        /// <summary>
        /// Gets or Sets the HipsResponse.
        /// Common Response Object.
        /// </summary>
        /// <value>
        /// The hipsResponse
        /// </value>
        [DataMember]
        public HipsResponse HipsResponse
        {
            get { return hipsResponse; }
            set { hipsResponse = value; }
        }

        /// <summary>
        /// Gets or sets the ivc code.
        /// </summary>
        /// <value>
        /// The ivc code.
        /// </value>
        [DataMember]
        public string IvcCode
        {
            get { return ivcCode; }
            set { ivcCode = value; }
        }

        /// <summary>
        /// Gets or sets the ivc expiry date.
        /// </summary>
        /// <value>
        /// The ivc expiry date.
        /// </value>
        [DataMember]
        public DateTime IvcExpiryDate
        {
            get { return ivcExpiryDate; }
            set { ivcExpiryDate = value; }
        }

        [DataMember]
        public int PatientMasterId
        {
            get { return patientMasterId; }
            set { patientMasterId = value; }
        }
        #endregion Properties
    }
}