﻿using System;
using System.Collections.Generic;
using System.Runtime.Serialization;
using Nehta.VendorLibrary.PCEHR;
using HIPS.PcehrDataStore.Schemas.Enumerators;

namespace HIPS.PcehrSchemas
{
    [KnownType(typeof(RegistrationDocumentConsent))]
    [Serializable]
    [DataContract]
    public class RegistrationDocumentConsent
    {
        #region Private Members

        #endregion Private Members

        #region Constructor

        /// <summary>
        /// Initializes a new instance of the <see cref="RegistrationDocumentConsent"/> class.
        /// </summary>
        public RegistrationDocumentConsent()
        {
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="RegistrationDocumentConsent"/> class.
        /// </summary>
        /// <param name="type">The type.</param>
        /// <param name="status">The status.</param>
        public RegistrationDocumentConsent(RegistrationDocumentConsentType type, RegistrationDocumentConsentStatus status)
        {
            this.DocumentConsentType = type;
            this.DocumentConsentStatus = status;
        }

        #endregion

        #region Properties

        /// <summary>
        /// Gets or sets the type of the document consent.
        /// </summary>
        /// <value>
        /// The type of the document consent.
        /// </value>
        [DataMember]
        public RegistrationDocumentConsentType DocumentConsentType
        {
            get; set;
        }

        /// <summary>
        /// Gets or sets the document consent status.
        /// </summary>
        /// <value>
        /// The document consent status.
        /// </value>
        [DataMember]
        public RegistrationDocumentConsentStatus DocumentConsentStatus
        {
            get;
            set;
        }

        #endregion Properties
    }
}