﻿namespace HIPS.PcehrSchemas
{
    /// <summary>
    /// sealed class with the Uuid mappings for the XDSDocumentEntry
    /// </summary>
    public sealed class UuidXDSDocumentEntry
    {
        //not for constructing
        private UuidXDSDocumentEntry()
        {
        }

        /// <summary>
        /// XDSDocumentEntry  ClassificationNode  R/R
        /// </summary>
        public static readonly string root = "urn:uuid:7edca82f-054d-47f2-a032-9b2a5b5186c1";

        /// <summary>
        /// XDSDocumentEntry.author  External Classification Scheme  R2/R
        /// </summary>
        public static readonly string author = "urn:uuid:93606bcf-9494-43ec-9b4e-a7748d1a838d";

        /// <summary>
        /// XDSDocumentEntry.classCode  External Classification Scheme  R/R
        /// </summary>
        public static readonly string classCode = "urn:uuid:41a5887f-8865-4c09-adf7-e362475b143a";

        /// <summary>
        ///XDSDocumentEntry.confidentialityCode  External Classification Scheme  R/P
        /// </summary>
        public static readonly string confidentialityCode = "urn:uuid:f4f85eac-e6cb-4883-b524-f2705394840f";

        /// <summary>
        ///XDSDocumentEntry.eventCodeList  External Classification Scheme  O/R
        /// </summary>
        public static readonly string eventCodeList = "urn:uuid:2c6b8cb7-8b2a-4051-b291-b1ae6a575ef4";

        /// <summary>
        ///XDSDocumentEntry.formatCode  External Classification Scheme  R/R
        /// </summary>
        public static readonly string formatCode = "urn:uuid:a09d5840-386c-46f2-b5ad-9c3699a4309d";

        /// <summary>
        ///XDSDocumentEntry.healthCareFacilityTypeCode  External Classification Scheme  R/R
        /// </summary>
        public static readonly string healthCareFacilityTypeCode = "urn:uuid:f33fb8ac-18af-42cc-ae0e-ed0b0bdb91e1";

        /// <summary>
        ///XDSDocumentEntry.patientId  ExternalIdentifier  R/R
        /// </summary>
        public static readonly string patientId = "urn:uuid:58a6f841-87b3-4a3e-92fd-a8ffeff98427";

        /// <summary>
        ///XDSDocumentEntry.practiceSettingCode  External Classification Scheme  R/R  (Also called Clinical Speciality Codes)
        /// </summary>
        public static readonly string practiceSettingCode = "urn:uuid:cccf5598-8b07-4b77-a05e-ae952c785ead";

        /// <summary>
        ///XDSDocumentEntry.typeCode  External Classification Scheme  R/R
        /// </summary>
        public static readonly string typeCode = "urn:uuid:f0306f51-975f-434e-a61c-c59651d33983";

        /// <summary>
        ///XDSDocumentEntry.uniqueId  ExternalIdentifier  R/R
        /// </summary>
        public static readonly string uniqueId = "urn:uuid:2e82c1f6-a085-4c72-9da3-8640a32e42ab";

        /// <summary>
        ///XDSDocumentEntry.limitedMetadata  ClassificationNode  Metadata Limited
        /// </summary>
        public static readonly string limitedMetadata = "urn:uuid:ab9b591b-83ab-4d03-8f5d-f93b1fb92e85";
    }
}