﻿using System;
using System.Runtime.Serialization;
using Nehta.VendorLibrary.PCEHR.PrescriptionAndDispenseView;

namespace HIPS.PcehrSchemas
{
    /// <summary>
    /// This object is used to pass the request to access the view from the PCEHR system.
    /// </summary>
    [Serializable]
    [DataContract]
    public class PrescriptionAndDispenseViewRequest : ViewRequestBase
    {
        #region Private Members

        /// The version number of the view corresponding to the namespace version.
        private const string VIEW_VERSION_NUMBER = "1.0";
        private DateTime fromDate;
        private DateTime toDate;

        #endregion Private Members

        #region Properties

        /// <summary>
        /// Gets or sets the from date.
        /// </summary>
        /// <value>
        /// Filter the view by start date value. Prescription or dispense clinical event date (serviceStopTime).
        /// </value>
        [DataMember]
        public DateTime FromDate
        {
            get { return fromDate; }
            set { fromDate = value; }
        }

        /// <summary>
        /// Gets or sets the to date.
        /// </summary>
        /// <value>
        /// Filter the view by end date value. Prescription or dispense clinical event date (serviceStopTime).
        /// </value>
        [DataMember]
        public DateTime ToDate
        {
            get { return toDate; }
            set { toDate = value; }
        }

        #endregion Properties

        #region Methods

        public override object ToNehtaLibraryObject()
        {
            prescriptionAndDispenseView nehta = new prescriptionAndDispenseView();
            nehta.fromDate = fromDate;
            nehta.toDate = toDate;
            nehta.versionNumber = VIEW_VERSION_NUMBER;
            return nehta;
        }

        #endregion Methods
    }
}