﻿using System;
using HIPS.AppServer.ServiceHost;
using HIPS.CommonSchemas;
using HIPS.PcehrSchemas;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Test.Helpers;
using HIPS.PcehrDataStore.DataAccess;
using HIPS.PcehrDataStore.Schemas;
using System.Xml;
using System.IO;
using HIPS.CommonSchemas.PatientIdentifier;
using HIPS.Client.Proxy;
using System.ServiceModel;
using HIPS.PcehrDataStore.Schemas.Enumerators;

namespace Test.PcehrBusinessLogic
{
    /// <summary>
    ///This is a test class for the Remove service and is intended
    ///to contain all PCEHRServiceTest Unit Tests
    ///</summary>
    [TestClass()]
    public class RemoveDocumentTest : PatientTestHelpersBase
    {
        #region Private Members
        private TestContext testContextInstance;
        private long timeStamp;
        private UserDetails defaultUser;
        #endregion

        #region Properties
        /// <summary>
        ///Gets or sets the test context which provides
        ///information about and functionality for the current test run.
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }

       
        #endregion

        #region Additional test attributes

        //
        //You can use the following additional attributes as you write your tests:
        //
        //Use ClassInitialize to run code before running the first test in the class
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //Use ClassCleanup to run code after all tests in a class have run
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //Use TestInitialize to run code before running each test
        //[TestInitialize()]
        //public void MyTestInitialize()
        //{
        //}
        //
        //Use TestCleanup to run code after each test has run
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //

        #endregion Additional test attributes

        #region Constructor
        public RemoveDocumentTest()
        {
            defaultUser = new UserDetails();
            defaultUser.Login = "GMASSE01";
            defaultUser.IsContractedServiceProvider = false;
            defaultUser.Name = "Gordon Massey";
            defaultUser.Domain = "HAD";
            defaultUser.Role = UserRole.InteractiveUser;
            //set the time stamp - using this for a quick and dirty unique id

            DateTime centuryBegin = new DateTime(2012, 1, 1);
            DateTime currentDate = DateTime.Now;
            long elapsedTicks = currentDate.Ticks - centuryBegin.Ticks;
            TimeSpan elapsedSpan = new TimeSpan(elapsedTicks);
            string ts = string.Format("{0:F0}",elapsedSpan.TotalMinutes);
            this.timeStamp = Convert.ToInt64(ts);
        }
        #endregion

        #region Methods Overriden from Base
        /// <summary>
        /// Gets the insert patient.
        /// </summary>
        override public void GetTestInsertPatient()
        {
            //PatientMaster result = new PatientMaster();
            TargetPatient.CurrentSexId = 1;
            TargetPatient.DateOfBirth = new DateTime(1940, 6, 8);
            TargetPatient.SetNewCurrentName(3, "Berman", "JAKE F", -1);

            // can populate these for fun even though they aren't used in this test
            TargetPatient.Addresses = GetAddresses();
            TargetPatient.Contacts = GetContacts();
        }

        /// <summary>
        /// Sets the test data.
        /// </summary>
        /// <returns></returns>
        public override int SetTestData()
        {
            ResetPatientData();
            //PatientTestHelpersBase testHelper = new PatientTestHelpersBase();
            GetTestInsertPatient();
            PatientMasterDl patientMasterDl = new PatientMasterDl(GetTestUser());
            bool result = patientMasterDl.Insert(TargetPatient);
            if (!result || !TargetPatient.PatientMasterId.HasValue)
            {
                Assert.Fail("The test patient was not saved");
            }
            return TargetPatient.PatientMasterId.Value;
        }
        #endregion

        /// <summary>
        ///A test for Remove
        ///</summary>
        [TestMethod()]
        public void RemoveTest()
        {
            string documentSetId = "1.2.36.1.2001.1005.26.2.1^10";
            Mrn mrnIdentifier = new Mrn("TEST-GM_03", "BER", "pasFacCd");
            DateTime admissionDate = new DateTime(2012, 11, 29);  // TODO: Initialize to an appropriate value

            //string expected = string.Empty; // TODO: Initialize to an appropriate value
            HipsResponse actual;
            //actual = target.UploadOrSupersedeDocument(cdaDocument, mrnIdentifier, defaultUser, attachments, admissionDate);

            using (PCEHRProxy proxy = new PCEHRProxy("PcehrEndPoint"))
            {
                try
                {
                    actual = proxy.Remove(mrnIdentifier, admissionDate, documentSetId, RemovalReason.IncorrectIdentity, defaultUser);
                }
                catch (EndpointNotFoundException ex)
                {
                    proxy.Abort();
                    throw new Exception("Connection could not be established", ex);
                }
                catch (Exception e)
                {
                    proxy.Abort();
                    throw e;
                }
            }
            
            if (actual.Status != HipsResponseIndicator.OK)
            {
                Assert.Fail("{0}", actual);
            }
        }
    }
}