﻿// -----------------------------------------------------------------------
// <copyright file="HpiOHelper.cs" company="NEHTA">
// Developed by Chamonix for NEHTA.
// </copyright>
// -----------------------------------------------------------------------

using System.Data.SqlClient;
using HIPS.CommonSchemas;
using HIPS.PcehrDataStore.Schemas;

namespace Test.CommonCcaNoc.Helpers
{
    /// <summary>
    /// Changes HIPS configuration to use invalid HPI-O and back to valid HPI-O.
    /// </summary>
    public class HpiOHelper
    {
        /// <summary>
        /// Changes the HPI-O from valid to invalid or back to valid.
        /// Tells HIPS to reload its reference data to pick up the change.
        /// </summary>
        /// <param name="patient"></param>
        /// <param name="test"></param>
        public static void ChangeHpiO(CcaPatient patient, CcaTest test, bool makeValid)
        {
            string oldHpiO = patient.TargetHospital.HpiO;
            string newHpiO = (long.Parse(oldHpiO) + 1).ToString();
            if (makeValid)
            {
                // Swap the values
                string temp = oldHpiO;
                oldHpiO = newHpiO;
                newHpiO = temp;
            }
            test.Log("Info: Changing HPI-O in database from {0} to {1}", oldHpiO, newHpiO);
            using (SqlCommand command = patient.TestCommand)
            {
                command.CommandText = string.Format(
                    @"UPDATE hips.HealthProviderOrganisation
                      SET HpiO = '{0}'
                      WHERE HpiO = '{1}'",
                    newHpiO,
                    oldHpiO);
                test.LogAssert.AreEqual(1, command.ExecuteNonQuery(), "Number of rows updated");
            }
            HipsResponse reloadResponse = ProxyHelper.ReferenceProxy.ReloadReferenceData(patient.GetTestUser());
            test.LogAssert.ExpectResponse(HipsResponseIndicator.OK, reloadResponse, DialogueResource.HipsServiceReloadReferenceData);
        }

        /// <summary>
        /// Switches the target hospital from one configured HPI-O to another.
        /// Tells HIPS to reload its reference data to pick up the change.
        ///
        /// The update will fail and an assertion will trigger if the given
        /// healthProviderOrganisationId does not exist in the database.
        /// </summary>
        /// <param name="patient">The CCA test patient</param>
        /// <param name="test">The current test</param>
        /// <param name="healthProviderOrganisationId">The ID of the HPI-O to switch to</param>
        public static void SwitchToHpiO(CcaPatient patient, CcaTest test, int healthProviderOrganisationId)
        {
            Hospital hospital = patient.TargetHospital;
            test.Log("Info: Changing hospital {0} from HPI-O {1} to HPI-O {2}",
                hospital.HospitalId, hospital.HealthProviderOrganisationId, healthProviderOrganisationId);
            using (SqlCommand command = patient.TestCommand)
            {
                command.CommandText = string.Format(
                    @"UPDATE hips.Hospital
                      SET HealthProviderOrganisationId = {0}
                      WHERE HospitalId = {1}",
                    healthProviderOrganisationId,
                    patient.TargetHospital.HospitalId);
                test.LogAssert.AreEqual(1, command.ExecuteNonQuery(), "Number of rows updated");
            }
            HipsResponse reloadResponse = ProxyHelper.ReferenceProxy.ReloadReferenceData(patient.GetTestUser());
            test.LogAssert.ExpectResponse(HipsResponseIndicator.OK, reloadResponse, DialogueResource.HipsServiceReloadReferenceData);
            patient.ReloadTargetHospital();
        }
    }
}