﻿using System.Configuration;
using HIPS.Client.Proxy;

namespace Test.CommonCcaNoc.Helpers
{
    /// <summary>
    /// Provides service proxies for use in CCA testing.
    /// </summary>
    public class ProxyHelper
    {
        #region Public Properties

        public static PCEHRProxy PcehrProxy
        {
            get
            {
                return new PCEHRProxy(string.Format("{0}_PCEHRService", EnvironmentUnderTest));
            }
        }

        public static ConsentProxy ConsentProxy
        {
            get
            {
                return new ConsentProxy(string.Format("{0}_ConsentService", EnvironmentUnderTest));
            }
        }

        public static ReferenceProxy ReferenceProxy
        {
            get
            {
                return new ReferenceProxy(string.Format("{0}_ReferenceService", EnvironmentUnderTest));
            }
        }

        public static AssistedRegistrationProxy AssistedRegistrationProxy
        {
            get
            {
                return new AssistedRegistrationProxy(string.Format("{0}_AssistedRegistrationService", EnvironmentUnderTest));
            }
        }

        #endregion Public Properties

        #region Private Properties

        public static string EnvironmentUnderTest
        {
            get
            {
                return ConfigurationManager.AppSettings["EnvironmentUnderTest"].ToString();
            }
        }

        #endregion Private Properties
    }
}