﻿// -----------------------------------------------------------------------
// <copyright file="SharedPackage.cs" company="NEHTA">
// Developed by Chamonix for NEHTA.
// </copyright>
// -----------------------------------------------------------------------

namespace Test.CommonCcaNoc.Helpers
{
    using System.Collections.Generic;
    using System.IO;
    using HIPS.PcehrDataStore.Schemas;
    using Ionic.Zip;

    /// <summary>
    /// This class allows multiple test methods to reuse the same uploaded document package.
    /// A shared instance is kept per document type, but reused for multiple tests.
    /// </summary>
    public class SharedPackage
    {
        public CcaPatient Patient { get; private set; }

        public CdaDocument CdaDocument { get; private set; }

        public CdaSignature CdaSignature { get; private set; }

        public ICollection<ZipEntry> PackageEntries { get; private set; }

        public ClinicalDocumentVersion Version { get; private set; }

        public byte[] Package { get; private set; }

        private static Dictionary<SampleDocumentType, SharedPackage> sharedInstances = new Dictionary<SampleDocumentType,SharedPackage>();

        public static SharedPackage GetSharedInstance(CcaTest test, SampleDocumentType docType)
        {
            SharedPackage sharedInstance;
            if (!sharedInstances.TryGetValue(docType, out sharedInstance))
            {
                sharedInstance = new SharedPackage();
                sharedInstance.Patient = CcaPatient.GetPatient(ihiValid: true, validatedWithinPeriod: true, hasUnresolvedAlerts: false, testDataId: "CCA ID IHI_85");
                CdaDocument cdaDocument = sharedInstance.Patient.CreateNewDocument(docType);
                QueueHelper.UploadDocumentAndWaitUntilProcessed(sharedInstance.Patient, test.LogAssert, cdaDocument);
                sharedInstance.Version = sharedInstance.Patient.GetLastClinicalDocumentVersion();
                sharedInstance.Package = sharedInstance.Version.Package;
                sharedInstance.CdaDocument = new CdaDocument(CdaPackage.ExtractDocument(sharedInstance.Package));
                sharedInstance.PackageEntries = ZipFile.Read(new MemoryStream(sharedInstance.Package)).Entries;
                sharedInstances[docType] = sharedInstance;
            }

            // A new test wants to use the shared instance. Reload the signature
            // because it wants a reference to the current test.
            test.patient = sharedInstance.Patient;
            sharedInstance.CdaSignature = new CdaSignature(CdaPackage.ExtractSignature(sharedInstance.Package), test);
            return sharedInstance;
        }

        /// <summary>
        /// This is a private constructor. Use GetSharedInstance method to obtain instances.
        /// </summary>
        private SharedPackage()
        {
        }
    }
}