﻿using System;
using System.Text;
using HIPS.CommonSchemas;
using HIPS.CommonSchemas.PatientIdentifier;
using HIPS.ConsentBusinessLogic;
using HIPS.ConsentSchemas;
using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace Test.ConsentBusinessLogic
{
    /// <summary>
    ///This is a test class for RecordPcehrDisclosure and is intended
    ///to contain all RecordPcehrDisclosure Unit Tests
    ///</summary>
    [TestClass()]
    public class RecordPcehrDisclosureTest
    {
        private TestContext testContextInstance;

        /// <summary>
        ///Gets or sets the test context which provides
        ///information about and functionality for the current test run.
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }

        #region Additional test attributes

        //
        //You can use the following additional attributes as you write your tests:
        //
        //Use ClassInitialize to run code before running the first test in the class
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //Use ClassCleanup to run code after all tests in a class have run
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //Use TestInitialize to run code before running each test
        //[TestInitialize()]
        //public void MyTestInitialize()
        //{
        //}
        //
        //Use TestCleanup to run code after each test has run
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //

        #endregion Additional test attributes

        #region TestMethods

        /// <summary>
        /// Test disclosure and check the participation status for the patient
        ///</summary>
        [TestMethod()]
        public void DisclosePcehrExistence()
        {
            try
            {
                RecordPcehrDisclosure businessLogic = new RecordPcehrDisclosure();
                Mrn patientIdentifier = new Mrn("04756147", "FMC", "pasFacCd");
                UserDetails user = new UserDetails();
                user.Role = UserRole.AuthorisedEmployee;
                byte[] auditInformation = Encoding.UTF8.GetBytes("Hello, world");
                HipsResponse expectedResponse = new HipsResponse(HipsResponseIndicator.OK);
                HipsResponse actualResponse = businessLogic.RecordDisclosure(true, patientIdentifier, user, auditInformation);
                RunTests(expectedResponse, actualResponse);

                CheckPatientParticipation checkBusinessLogic = new CheckPatientParticipation();
                PatientParticipationResponse checkActual = checkBusinessLogic.GetPatientParticipationStatus(patientIdentifier, user);
                PatientParticipationResponse checkExpected = new PatientParticipationResponse();
                checkExpected.Response = expectedResponse;
                checkExpected.PatientParticipationList = new PatientParticipationStatus[]
                {
                    new PatientParticipationStatus()
                    {
                        Mrn = patientIdentifier.Value,
                        HospitalCode = patientIdentifier.HospitalCode,
                        ParticipationStatus = ParticipationStatus.RequestedUpload
                    }
                };
                RunTests(checkExpected, checkActual);
            }
            catch (Exception ex)
            {
                Assert.Fail(string.Format("Encountered an error {0}", ex.Message));
            }
        }

        /// <summary>
        /// Test rescinding the disclosure and check the participation status for the patient
        ///</summary>
        [TestMethod()]
        public void RescindPcehrExistenceDisclosure()
        {
            try
            {
                RecordPcehrDisclosure businessLogic = new RecordPcehrDisclosure();
                Mrn patientIdentifier = new Mrn("04756147", "FMC", "pasFacCd");
                UserDetails user = new UserDetails();
                user.Role = UserRole.AuthorisedEmployee;
                byte[] auditInformation = Encoding.UTF8.GetBytes("Hello, world");
                HipsResponse expectedResponse = new HipsResponse(HipsResponseIndicator.OK);
                HipsResponse actualResponse = businessLogic.RecordDisclosure(false, patientIdentifier, user, auditInformation);
                RunTests(expectedResponse, actualResponse);

                CheckPatientParticipation checkBusinessLogic = new CheckPatientParticipation();
                PatientParticipationResponse checkActual = checkBusinessLogic.GetPatientParticipationStatus(patientIdentifier, user);
                PatientParticipationResponse checkExpected = new PatientParticipationResponse();
                checkExpected.Response = expectedResponse;
                checkExpected.PatientParticipationList = new PatientParticipationStatus[]
                {
                    new PatientParticipationStatus()
                    {
                        Mrn = patientIdentifier.Value,
                        HospitalCode = patientIdentifier.HospitalCode,
                        ParticipationStatus = ParticipationStatus.PcehrNotAdvertised
                    }
                };
                RunTests(checkExpected, checkActual);
            }
            catch (Exception ex)
            {
                Assert.Fail(string.Format("Encountered an error {0}", ex.Message));
            }
        }

        private void RunTests(HipsResponse expected, HipsResponse actual)
        {
            if (expected.Status != actual.Status)
            {
                Assert.Fail("Expected and Actual status do not match");
            }
        }

        private void RunTests(PatientParticipationResponse expected, PatientParticipationResponse actual)
        {
            if (expected.Response.Status != actual.Response.Status)
            {
                Assert.Fail("Expected and Actual response status do not match");
            }
            if (expected.PatientParticipationList[0].Mrn != actual.PatientParticipationList[0].Mrn)
            {
                Assert.Fail("Expected and Actual MRN do not match");
            }
            if (expected.PatientParticipationList[0].HospitalCode != actual.PatientParticipationList[0].HospitalCode)
            {
                Assert.Fail("Expected and Actual hospital code do not match");
            }
            if (expected.PatientParticipationList[0].ParticipationStatus != actual.PatientParticipationList[0].ParticipationStatus)
            {
                Assert.Fail("Expected and Actual participation status do not match");
            }
        }

        #endregion TestMethods
    }
}