﻿using System;
using System.Globalization;
using System.Text;
using HIPS.CommonSchemas;
using HIPS.CommonSchemas.PatientIdentifier;
using HIPS.ConsentBusinessLogic;
using HIPS.ConsentSchemas;
using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace Test.ConsentBusinessLogic
{
    /// <summary>
    ///This is a test class for RecordUploadConsent and is intended
    ///to contain all RecordUploadConsent Unit Tests
    ///</summary>
    [TestClass()]
    public class RecordUploadConsentTest
    {
        private TestContext testContextInstance;

        /// <summary>
        ///Gets or sets the test context which provides
        ///information about and functionality for the current test run.
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }

        #region Additional test attributes

        //
        //You can use the following additional attributes as you write your tests:
        //
        //Use ClassInitialize to run code before running the first test in the class
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //Use ClassCleanup to run code after all tests in a class have run
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //Use TestInitialize to run code before running each test
        //[TestInitialize()]
        //public void MyTestInitialize()
        //{
        //}
        //
        //Use TestCleanup to run code after each test has run
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //

        #endregion Additional test attributes

        #region TestMethods

        /// <summary>
        /// Test successful RecordConsent and CheckConsent
        ///</summary>
        [TestMethod()]
        public void RecordConsent()
        {
            try
            {
                RecordUploadConsent businessLogic = new RecordUploadConsent();
                PatientIdentifierBase patientIdentifier = new Mrn("04756147", "FMC", "pasFacCd");
                DateTime admissionDate = DateTime.ParseExact("2012-07-16 09:00:00.000", "yyyy-MM-dd HH:mm:ss.fff", CultureInfo.InvariantCulture);
                UserDetails user = new UserDetails();
                user.Role = UserRole.AuthorisedEmployee;
                byte[] auditInformation = Encoding.UTF8.GetBytes("Hello, world");
                HipsResponse expected = new HipsResponse(HipsResponseIndicator.OK);
                HipsResponse actual = businessLogic.RecordConsent(true, patientIdentifier, admissionDate, user, auditInformation);
                RunTests(expected, actual);

                CheckUploadConsent checkBusinessLogic = new CheckUploadConsent();
                EpisodeConsentResponse expected2 = new EpisodeConsentResponse();
                expected2.Response = expected;
                expected2.ConsentStatus = EpisodeConsentStatus.WithdrewConsent;
                EpisodeConsentResponse actual2 = checkBusinessLogic.CheckConsent(patientIdentifier, admissionDate, user);
                RunTests(expected2, actual2);
            }
            catch (Exception ex)
            {
                Assert.Fail(string.Format("Encountered an error {0}", ex.Message));
            }
        }

        private void RunTests(HipsResponse expected, HipsResponse actual)
        {
            if (expected.Status != actual.Status)
            {
                Assert.Fail("Expected and Actual status do not match");
            }
        }

        private void RunTests(EpisodeConsentResponse expected, EpisodeConsentResponse actual)
        {
            if (expected.Response.Status != actual.Response.Status)
            {
                Assert.Fail("Expected and Actual response status do not match");
            }
            if (expected.ConsentStatus != actual.ConsentStatus)
            {
                Assert.Fail("Expected and Actual consent status do not match");
            }
        }

        #endregion TestMethods
    }
}