﻿using System;
using System.Collections.Generic;
using System.Configuration;
using System.Data.SqlClient;
using System.Data.SqlServerCe;
using HIPS.PcehrDataStore.Schemas;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using nehta.mcaR50.ProviderSearchForProviderIndividual;
using Test.Helpers;

namespace Test.MedicareCCA.Helpers
{
    public class CcaProviders : ProviderTestHelpersBase
    {
        private SqlCeConnection ccaTestProvidersConnectionField;

        private SqlCeConnection CcaTestProvidersConnection
        {
            get
            {
                if (ccaTestProvidersConnectionField == null)
                {
                    string connectionString = ConfigurationManager.ConnectionStrings["CcaTestProvidersConnectionString"].ConnectionString;
                    ccaTestProvidersConnectionField = new SqlCeConnection(connectionString);
                    ccaTestProvidersConnectionField.Open();
                }
                return ccaTestProvidersConnectionField;
            }
        }

        private SqlCeCommand GetCcaTestProvidersCommand()
        {
            return CcaTestProvidersConnection.CreateCommand();
        }

        /// <summary>
        /// Which of the rows in the CcaTestProviders table TestHpii has the data for this provider.
        /// </summary>
        public string TestDataId
        {
            get;
            set;
        }

        private Dictionary<string, string> testProviderField;

        private Dictionary<string, string> TestProvider
        {
            get
            {
                if (testProviderField == null)
                {
                    testProviderField = new Dictionary<string, string>();
                    using (SqlCeCommand c = GetCcaTestProvidersCommand())
                    {
                        c.CommandText = string.Format("SELECT * FROM TestHpii WHERE TestDataId='{0}'", TestDataId);
                        SqlCeResultSet resultSet = c.ExecuteResultSet(ResultSetOptions.None);
                        bool gotRow = resultSet.Read();
                        Assert.IsTrue(gotRow, DialogueResource.TestDataIdNotFound, TestDataId);
                        for (int i = 0; i < resultSet.FieldCount; i++)
                        {
                            testProviderField[resultSet.GetName(i)] = resultSet.GetString(i);
                        }
                    }
                }
                return testProviderField;
            }
        }

        public static CcaProviders GetProvdier(string testDataId)
        {
            CcaProviders item = new CcaProviders();
            item.TestDataId = testDataId;
            return item;
        }

        /// <summary>
        /// The family name for the test provider.
        /// </summary>
        public string TestProviderFamilyName
        {
            get
            {
                return TestProvider["FamilyName"];
            }
        }

        /// <summary>
        /// The first given name for the test provider.
        /// </summary>
        public string TestProviderFirstGivenName
        {
            get
            {
                return TestProvider["FirstGivenName"];
            }
        }

        /// <summary>
        /// The second given name for the test provider.
        /// </summary>
        public string TestProviderSecondGivenName
        {
            get
            {
                return TestProvider["SecondGivenName"];
            }
        }

        /// <summary>
        /// The sex for the test provider.
        /// </summary>
        public SexType TestProviderSex
        {
            get
            {
                return (SexType)Enum.Parse(typeof(SexType), TestProvider["Sex"]);
            }
        }

        /// <summary>
        /// The date of birth for the test provider.
        /// </summary>
        public DateTime TestProviderDateOfBirth
        {
            get
            {
                return DateTime.Parse(TestProvider["DateOfBirth"]);
            }
        }

        /// <summary>
        /// The Only Name Indicator for the test provider.
        /// </summary>
        public string TestProviderOnlyNameIndicator
        {
            get
            {
                return TestProvider["OnlyNameIndicator"];
            }
        }

        /// <summary>
        /// The HpioNumber for the test provider.
        /// </summary>
        public string TestProviderHpioNumber
        {
            get
            {
                return TestProvider["HpioNumber"];
            }
        }

        /// <summary>
        /// The HpiiNumber for the test provider.
        /// </summary>
        public string TestProviderHpiiNumber
        {
            get
            {
                return TestProvider["HpiiNumber"];
            }
        }

        /// <summary>
        /// The StreetNumber for the test provider.
        /// </summary>
        public string TestProviderStreetNumber
        {
            get
            {
                return TestProvider["StreetNumber"];
            }
        }

        /// <summary>
        /// The StreetName for the test provider.
        /// </summary>
        public string TestProviderStreetName
        {
            get
            {
                return TestProvider["StreetName"];
            }
        }

        /// <summary>
        /// The StreetType for the test provider.
        /// </summary>
        public StreetType TestProviderStreetType
        {
            get
            {
                return (StreetType)Enum.Parse(typeof(StreetType), TestProvider["StreetType"]);
            }
        }

        /// <summary>
        /// The PostCode for the test provider.
        /// </summary>
        public string TestProviderPostCode
        {
            get
            {
                return TestProvider["PostCode"];
            }
        }

        /// <summary>
        /// The State for the test provider.
        /// </summary>
        public StateType TestProviderState
        {
            get
            {
                return (StateType)Enum.Parse(typeof(StateType), TestProvider["State"]);
            }
        }

        /// <summary>
        /// The Suburb for the test provider.
        /// </summary>
        public string TestProviderSuburb
        {
            get
            {
                return TestProvider["Suburb"];
            }
        }

        /// <summary>
        /// Gets the last IHI lookup audit record.
        /// </summary>
        /// <returns></returns>
        internal HpiiLookupAudit GetLastHpiiLookupAudit()
        {
            GenericDataAccess dataAccess = new GenericDataAccess();
            HpiiLookupAudit result = new HpiiLookupAudit();
            using (SqlCommand command = TestCommand)
            {
                command.CommandText = "SELECT TOP 1 a.*, s.Code AS Sex FROM [hips].[HpiiLookupAudit] a LEFT JOIN hips.sex s ON a.SexId = s.SexId ORDER BY HpiiLookupAuditId DESC";
                PopulateBusinessObject<HpiiLookupAudit>(command.ExecuteReader(), result);
            }
            return result;
        }
    }
}