﻿using System.Configuration;
using HIPS.Client.Proxy;

namespace Test.MedicareCCCA.Helpers
{
    /// <summary>
    /// Provides service proxies for use in CCA testing.
    /// </summary>
    public class ProxyHelper
    {
        #region Public Properties

        public static IHIProxy IhiProxy
        {
            get
            {
                return new IHIProxy(string.Format("{0}_IHIService", EnvironmentUnderTest));
            }
        }

        public static HpiiProxy HpiiProxy
        {
            get
            {
                return new HpiiProxy(string.Format("{0}_HpiiService", EnvironmentUnderTest));
            }
        }

        #endregion Public Properties

        #region Private Properties

        private static string EnvironmentUnderTest
        {
            get
            {
                return ConfigurationManager.AppSettings["EnvironmentUnderTest"].ToString();
            }
        }

        #endregion Private Properties
    }
}