﻿using HIPS.CommonSchemas;
using HIPS.HpiiSchemas;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using nehta.mcaR50.ProviderSearchForProviderIndividual;
using Test.Helpers;
using Test.MedicareCca.Helpers;
using Test.MedicareCCA.Helpers;
using Test.MedicareCCCA.Helpers;

namespace Test.MedicareCCA.NoticeOfConnection.HPII
{
    [TestClass]
    public class NOC_HPIIIndividualSearch : CcaTest
    {
        /// HPII Inquiry Search via B2B (Reference: TECH.SIS.HI.31)
        /// Test 20.1 - Positive Hpii Validation
        /// </summary>
        [TestMethod]
        [TestCategory("HI_NOC_HPI-I_Individual_Search")]
        public void HI_NOC_TECH_SIS_HI_31_TEST_20_1()
        {
            UserDetails user = new ProviderTestHelpersBase().GetTestUser();

            provider = CcaProviders.GetProvdier("NOC ID 1");

            HpiiIdentifierQuery query = new HpiiIdentifierQuery();
            query.HpioNumber = provider.TestProviderHpioNumber;
            query.HpiiNumber = provider.TestProviderHpiiNumber;
            query.FamilyName = provider.TestProviderFamilyName;
            query.Sex = (SexType?)provider.TestProviderSex;

            HpiiQueryResponse hpiiResponse = ProxyHelper.HpiiProxy.HpiiValidation(query, user);

            LogAssert.ExpectResponse(HipsResponseIndicator.OK, hpiiResponse.HipsResponse, DialogueResource.HipsServiceHpiiValidation);
            LogAssert.AreEqual(provider.TestProviderHpiiNumber, hpiiResponse.HpiiNumber, DialogueResource.HpiiNumber);
        }

        /// HPII  Inquiry Search via B2B (Reference: TECH.SIS.HI.31)
        /// Test 20.2 - Positive Demographic Search
        /// </summary>
        [TestMethod]
        [TestCategory("HI_NOC_HPI-I_Individual_Search")]
        public void HI_NOC_TECH_SIS_HI_31_TEST_20_2()
        {
            UserDetails user = new ProviderTestHelpersBase().GetTestUser();

            provider = CcaProviders.GetProvdier("NOC ID 1");

            HpiiDemographicQuery query = new HpiiDemographicQuery();
            query.HpioNumber = provider.TestProviderHpioNumber;
            query.FamilyName = provider.TestProviderFamilyName;
            query.DateofBirth = provider.TestProviderDateOfBirth;
            string[] names = new string[2];
            names[0] = provider.TestProviderFirstGivenName;
            //query.GivenName = names;
            query.Sex = (SexType?)provider.TestProviderSex;

            query.AustralianAddress = new AustralianAddress();
            query.AustralianAddress.Suburb = provider.TestProviderSuburb;
            query.AustralianAddress.State = provider.TestProviderState;
            query.AustralianAddress.PostCode = provider.TestProviderPostCode;
            //oddly this is expected when it is not stated in the specifications
            query.AustralianAddress.StreetName = provider.TestProviderStreetName;

            HpiiQueryResponse hpiiResponse = ProxyHelper.HpiiProxy.HpiiDemographicSearch(query, user);

            LogAssert.ExpectResponse(HipsResponseIndicator.OK, hpiiResponse.HipsResponse, DialogueResource.HipsServiceHpiiDemographicSearch);
            LogAssert.AreEqual(provider.TestProviderHpiiNumber, hpiiResponse.HpiiNumber, DialogueResource.HpiiNumber);
            LogAssert.AreEqual(provider.TestProviderFamilyName, hpiiResponse.FamilyName, DialogueResource.HpiiFamilyName);
            LogAssert.AreEqual(provider.TestProviderDateOfBirth, hpiiResponse.DateofBirth, DialogueResource.HpiiDateOfBirth);
        }

        /// HPII  Inquiry Search via B2B (Reference: TECH.SIS.HI.31)
        /// Test 20.3- Positive Demographic Search with Multiple Given Names
        /// </summary>
        [TestMethod]
        [TestCategory("HI_NOC_HPI-I_Individual_Search")]
        public void HI_NOC_TECH_SIS_HI_31_TEST_20_3()
        {
            UserDetails user = new ProviderTestHelpersBase().GetTestUser();

            provider = CcaProviders.GetProvdier("NOC ID 3");

            HpiiDemographicQuery query = new HpiiDemographicQuery();
            query.HpioNumber = provider.TestProviderHpioNumber;
            query.FamilyName = provider.TestProviderFamilyName;
            query.DateofBirth = provider.TestProviderDateOfBirth;
            string[] names = new string[2];
            names[0] = provider.TestProviderFirstGivenName;
            names[1] = provider.TestProviderSecondGivenName;
            query.GivenName = names;
            query.Sex = (SexType?)provider.TestProviderSex;

            query.AustralianAddress = new AustralianAddress();
            query.AustralianAddress.Suburb = provider.TestProviderSuburb;
            query.AustralianAddress.State = provider.TestProviderState;
            query.AustralianAddress.PostCode = provider.TestProviderPostCode;
            //oddly this is expected when it is not stated in the specifications
            query.AustralianAddress.StreetName = provider.TestProviderStreetName;

            HpiiQueryResponse hpiiResponse = ProxyHelper.HpiiProxy.HpiiDemographicSearch(query, user);

            LogAssert.ExpectResponse(HipsResponseIndicator.OK, hpiiResponse.HipsResponse, DialogueResource.HipsServiceHpiiDemographicSearch);
            LogAssert.AreEqual(provider.TestProviderHpiiNumber, hpiiResponse.HpiiNumber, DialogueResource.HpiiNumber);
            LogAssert.AreEqual(provider.TestProviderFamilyName, hpiiResponse.FamilyName, DialogueResource.HpiiFamilyName);
            LogAssert.AreEqual(provider.TestProviderFirstGivenName, hpiiResponse.GivenName[0], string.Format(DialogueResource.HpiiGivenNames, "First"));
            LogAssert.AreEqual(provider.TestProviderSecondGivenName, hpiiResponse.GivenName[1], string.Format(DialogueResource.HpiiGivenNames, "Second"));
            LogAssert.AreEqual(provider.TestProviderDateOfBirth, hpiiResponse.DateofBirth, DialogueResource.HpiiDateOfBirth);
        }

        /// HPII  Inquiry Search via B2B (Reference: TECH.SIS.HI.31)
        /// Test 20.4 - Negative Demographic Search no found individual
        /// </summary>
        [TestMethod]
        [TestCategory("HI_NOC_HPI-I_Individual_Search")]
        public void HI_NOC_TECH_SIS_HI_31_TEST_20_4()
        {
            UserDetails user = new ProviderTestHelpersBase().GetTestUser();

            provider = CcaProviders.GetProvdier("NOC ID 2");

            HpiiDemographicQuery query = new HpiiDemographicQuery();
            query.HpioNumber = provider.TestProviderHpioNumber;
            query.FamilyName = provider.TestProviderFamilyName;
            query.DateofBirth = provider.TestProviderDateOfBirth;
            string[] names = new string[1];
            names[0] = provider.TestProviderFirstGivenName;
            query.GivenName = names;
            query.Sex = (SexType?)provider.TestProviderSex;

            query.AustralianAddress = new AustralianAddress();
            query.AustralianAddress.Suburb = provider.TestProviderSuburb;
            query.AustralianAddress.State = provider.TestProviderState;
            query.AustralianAddress.PostCode = provider.TestProviderPostCode;
            //oddly this is expected when it is not stated in the specifications
            query.AustralianAddress.StreetName = provider.TestProviderStreetName;

            HpiiQueryResponse hpiiResponse = ProxyHelper.HpiiProxy.HpiiDemographicSearch(query, user);

            LogAssert.ExpectResponse(HipsResponseIndicator.OK, hpiiResponse.HipsResponse, DialogueResource.HipsServiceHpiiDemographicSearch);
            LogAssert.AreEqual(hpiiResponse.HipsResponse.ResponseCode, "WSE0035", DialogueResource.HpiiResponseCode);
            LogAssert.AreEqual(hpiiResponse.HipsResponse.ResponseCodeDetails, "No records have been found", DialogueResource.HpiiResponseDetails);
        }
    }
}