﻿using System;
using System.Data.SqlClient;
using HIPS.CommonBusinessLogic.Singleton;
using HIPS.CommonSchemas;
using HIPS.HibIntegration.HL7;
using HIPS.HibIntegration.Loader;
using HIPS.PcehrDataStore.Schemas;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Test.Helpers;

namespace Test.HibIntegration
{
    /// <summary>
    ///This is a test class for MessageLoaderTest and is intended
    ///to contain all MessageLoaderTest Unit Tests
    ///</summary>
    [TestClass()]
    public class MessageLoaderTest : PatientTestHelpersBase
    {
        #region properties

        private TestContext testContextInstance;

        /// <summary>
        ///Gets or sets the test context which provides
        ///information about and functionality for the current test run.
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }

        private PatientTestHelpersBase helpers = new PatientTestHelpersBase();

        /// <summary>
        /// Gets the Helpers.
        /// </summary>
        private PatientTestHelpersBase Helpers
        {
            get
            {
                if (this.helpers == null)
                {
                    helpers = new PatientTestHelpersBase();
                }
                return helpers;
            }
        }

        #endregion properties

        #region Additional test attributes

        //
        //You can use the following additional attributes as you write your tests:
        //
        //Use ClassInitialize to run code before running the first test in the class
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //Use ClassCleanup to run code after all tests in a class have run
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //Use TestInitialize to run code before running each test
        //[TestInitialize()]
        //public void MyTestInitialize()
        //{
        //}
        //
        //Use TestCleanup to run code after each test has run
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //

        #endregion Additional test attributes

        #region tests

        /// <summary>
        /// A test for Process
        /// </summary>
        [TestMethod()]
        public void NewSuffixAndTitleTest()
        {
            try
            {
                base.ResetPatientData();
                ResetTitleSuffix();
                ListSingleton lists = ListSingleton.Instance;
                lists.Refresh(true);
                MessageLoader target = new MessageLoader();
                HL7Message message = HL7Message.Parse(HL7TestMessage.PasPatientLoad);
                UserDetails user = this.SetUser();
                HL7MessageLog testMessageLog = null;
                HL7Message actual = target.Process(message, HL7TestMessage.PasPatientLoad, user, out testMessageLog);
                PatientMaster patientMaster = Helpers.GetPatientByMrn("00109444");
                if (patientMaster.CurrentName.TitleId != -1)
                {
                    Assert.Fail("Title is not set correctly");
                }
                if (patientMaster.CurrentName.SuffixId != -1)
                {
                    Assert.Fail("Suffix is not set correctly");
                }

                //run it again with an adjusted message
                message = HL7Message.Parse(HL7TestMessage.PasPatientSuffixTitleChange);
                actual = target.Process(message, HL7TestMessage.PasPatientSuffixTitleChange, user, out testMessageLog);

                patientMaster = Helpers.GetPatientByMrn("00109444");

                if ("IIIrd" != patientMaster.CurrentName.Suffix)
                {
                    Assert.Fail("Name Suffix not updated");
                }

                if ("TESTMR" != patientMaster.CurrentName.Title)
                {
                    Assert.Fail("Name Title not updated");
                }

                //clean up patient data
                base.ResetPatientData();
            }
            catch (Exception ex)
            {
                Assert.Fail(ex.Message);
            }
        }

        #endregion tests

        #region helpers

        ///// <summary>
        ///// Gets the patient by MRN.
        ///// </summary>
        ///// <param name="mrn">The MRN.</param>
        ///// <returns></returns>
        //public PatientMaster GetPatientByMrn(string mrn)
        //{
        //    GenericDataAccess dataAccess = new GenericDataAccess();
        //    PatientMaster result = new PatientMaster();
        //    using (SqlCommand command = TestCommand)
        //    {
        //        command.CommandText = string.Format("SELECT *, pmi.DateLastValidated AS IhiLastValidated FROM [hips].[PatientMaster] pm LEFT JOIN [hips].[patient] AS p on p.PatientMasterId = pm.PatientMasterId LEFT OUTER JOIN [hips].[PatientMasterIhi] AS pmi ON pmi.PatientMasterId = p.PatientMasterId WHERE mrn = '{0}'", mrn);
        //        PopulateBusinessObject<PatientMaster>(command.ExecuteReader(), result);
        //        command.CommandText = string.Format("SELECT * FROM [hips].[PatientMasterName] pmn LEFT JOIN [hips].[patient] AS p on p.PatientMasterId = pmn.PatientMasterId WHERE mrn = '{0}'", mrn);
        //        result.Names = GetPopulatedBusinessList<PatientMasterName>(command.ExecuteReader());
        //        command.Connection.Close();
        //    }
        //    return result;
        //}

        public void ResetTitleSuffix()
        {
            using (SqlCommand command = TestCommand)
            {
                command.CommandText = "DELETE [hips].[Title] WHERE CODE = 'TESTMR'";
                int result = command.ExecuteNonQuery();
                command.CommandText = "DELETE [hips].[Suffix] WHERE CODE = 'IIIrd'";
                result = command.ExecuteNonQuery();
                command.Connection.Close();
            }
        }

        /// <summary>
        /// Sets the user.
        /// </summary>
        /// <returns></returns>
        private UserDetails SetUser()
        {
            UserDetails defaultUser = new UserDetails();
            defaultUser.AuthorisedEmployeeUserId = "AEUID";
            defaultUser.Login = "HAD/SANDEENM";
            defaultUser.HpiI = "8003619900000081";
            defaultUser.IsContractedServiceProvider = false;
            defaultUser.Name = "David Johnston (CIO)";
            defaultUser.Role = UserRole.AuthorisedEmployee;
            return defaultUser;
        }

        /// <summary>
        /// Gets the insert patient.
        /// This allows me to use the base class to clean up the data
        /// </summary>
        override public void GetTestInsertPatient()
        {
            //PatientMaster result = new PatientMaster();
            TargetPatient.CurrentSexId = 1;
            TargetPatient.DateOfBirth = new DateTime(1930, 11, 05);

            // This patient should return a valid IHI
            TargetPatient.MedicareNumber = "5034886606";
            TargetPatient.MedicareIrn = "1";
            TargetPatient.IsMedicareNumberValid = true;

            TargetPatient.SetNewCurrentName(1, "HERBERT HENRY", "JUSTIN", 1);

            // can populate these for fun even though they aren't used in this test
            //TargetPatient.Addresses = GetAddresses();
            //TargetPatient.Contacts = GetContacts();
        }

        public override string SqlCommandText()
        {
            return string.Format("SELECT PatientMasterId FROM hips.PatientMaster  WHERE DateOfBirth = '{0:yyyy-MM-dd}' AND MedicareNumber = '{1}'", TargetPatient.DateOfBirth, TargetPatient.MedicareNumber);
        }

        #endregion helpers
    }
}