﻿using System;
using System.Collections.Generic;
using System.Configuration;
using HIPS.CommonBusinessLogic.Singleton;
using HIPS.CommonSchemas;
using HIPS.IhiSchemas.Schemas;
using HIPS.PcehrDataStore.Schemas;
using HIPS.PcehrHiBusinessLogic.Ihi;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using nehta.mcaR3.ConsumerSearchIHI;

namespace Test.IhiBusinessLogic
{
    /// <summary>
    ///This is a test class for SearchTest and is intended
    ///to contain all SearchTest Unit Tests
    ///</summary>
    [TestClass()]
    public class SearchTest
    {
        #region properties

        private TestContext testContextInstance;
        private UserDetails defaultUser;
        private IhiSearchCriteria ihiSearchCriteria;
        private PatientMaster patientMaster;

        #endregion properties

        #region constructor

        public SearchTest()
        {
            defaultUser = new UserDetails();
            defaultUser.AuthorisedEmployeeUserId = "AEUID";
            defaultUser.Login = "HAD/SANDEENM";
            defaultUser.HpiI = "8003619900000081";
            defaultUser.IsContractedServiceProvider = false;
            defaultUser.Name = "David Johnston (CIO)";
            defaultUser.Role = UserRole.AuthorisedEmployee;

            ihiSearchCriteria = this.GetIhiSearchCriteria();
        }

        #endregion constructor

        /// <summary>
        ///Gets or sets the test context which provides
        ///information about and functionality for the current test run.
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }

        #region Additional test attributes

        //
        //You can use the following additional attributes as you write your tests:
        //
        //Use ClassInitialize to run code before running the first test in the class
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //Use ClassCleanup to run code after all tests in a class have run
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //Use TestInitialize to run code before running each test
        //[TestInitialize()]
        //public void MyTestInitialize()
        //{
        //}
        //
        //Use TestCleanup to run code after each test has run
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //

        #endregion Additional test attributes

        #region Tests

        /// <summary>
        /// A test for Getting a valid IHI
        /// </summary>
        [TestMethod()]
        public void GetValidIhiTest()
        {
            try
            {
                TestRepeater();
            }
            catch (Exception ex)
            {
                Assert.Fail(string.Format("Encountered an error {0}", ex.Message));
            }
        }

        /// <summary>
        /// Checks the existing ihi test.
        /// </summary>
        [TestMethod()]
        public void CheckExistingIhiTest()
        {
            try
            {
                ihiSearchCriteria.Ihi = "8003604570631431";
                TestRepeater();
            }
            catch (Exception ex)
            {
                Assert.Fail(string.Format("Encountered an error {0}", ex.Message));
            }
        }

        /// <summary>
        /// Gets the expired ihi test.
        /// </summary>
        [TestMethod()]
        public void GetExpiredIhiTest()
        {
            try
            {
                ihiSearchCriteria.Ihi = "8003604570631431";

                //this should force a new IHI Search
                //string dateOffset = ConfigurationManager.AppSettings["IhiValidationPeriodDays"];
                int dateOffset = Convert.ToInt32(ConfigurationManager.AppSettings["IhiValidationPeriodDays"]) * -1;
                ihiSearchCriteria.IhiLastUpdated = DateTime.Now.AddDays(dateOffset);

                //DateTime previousDate = ihiSearchCriteria.IhiLastUpdated = DateTime.Now.AddDays(dateOffset);

                TestRepeater();
                if (DateTime.Now.Date != ihiSearchCriteria.IhiLastUpdated.Date)
                {
                    Assert.Fail("IHI search didn't return current date");
                }
            }
            catch (Exception ex)
            {
                Assert.Fail(string.Format("Encountered an error {0}", ex.Message));
            }
        }

        #endregion Tests

        #region Helpers

        /// <summary>
        /// Repeats the test, but lets us seed with different values.
        /// </summary>
        private void TestRepeater()
        {
            Hospital hospital = HospitalSingleton.Value.Find(22);
            string resultMessage = string.Empty;
            searchIHIResponse ihiResponse = null;
            string expectedIhi = "8003604570631431";

            bool checkPcehr = false;

            bool actual = Search.ByNumber(hospital, patientMaster, ihiSearchCriteria, out resultMessage, out ihiResponse, defaultUser, checkPcehr);
            if (!actual)
            {
                Assert.Fail(string.Format("Error in IHI search {0}", resultMessage));
            }
            else
            {
                if (expectedIhi != ihiSearchCriteria.Ihi)
                {
                    Assert.Fail("Returned IHI does not match expected IHI");
                }
            }
        }

        /// <summary>
        /// Gets the ihi search criteria.
        /// </summary>
        /// <returns></returns>
        private IhiSearchCriteria GetIhiSearchCriteria()
        {
            IhiSearchCriteria searchCriteria = new IhiSearchCriteria();
            searchCriteria.DateOfBirth = new DateTime(1928, 1, 16);

            SpecificIhiTest testHelper = new SpecificIhiTest();
            searchCriteria.PatientMasterId = testHelper.SetTestData();
            patientMaster = testHelper.TargetPatient;

            IhiSearchCriteriaName name = new IhiSearchCriteriaName();

            name.FamilyName = "Forde";
            name.GivenName = "Frederick";
            name.Sex = HIPS.PcehrDataStore.Schemas.Enumerators.SexEnumerator.Male;
            name.SuffixId = -1;
            name.TitleId = 1;
            searchCriteria.Names = new List<IhiSearchCriteriaName>();

            searchCriteria.Names.Add(name);
            searchCriteria.MedicareNumber = "2950189841";
            searchCriteria.IsMedicareNumberValid = true;
            searchCriteria.MedicareIrn = "1";
            searchCriteria.DvaNumber = "NX623461";
            searchCriteria.PcehrExists = false;
            return searchCriteria;
        }

        #endregion Helpers
    }
}