﻿using System;
using HIPS.PcehrDataStore.DataAccess;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Test.Helpers;

namespace Test.IhiBusinessLogic
{
    public class SpecificIhiTest : PatientTestHelpersBase
    {
        #region Methods Overridden from Base

        /// <summary>
        /// Gets the insert patient.
        /// </summary>
        override public void GetTestInsertPatient()
        {
            //PatientMaster result = new PatientMaster();
            TargetPatient.CurrentSexId = 1;
            TargetPatient.DateOfBirth = new DateTime(1940, 11, 20);

            // This patient should return a valid IHI
            TargetPatient.MedicareNumber = "4950219221";
            TargetPatient.MedicareIrn = "1";
            TargetPatient.IsMedicareNumberValid = false;

            TargetPatient.SetNewCurrentName(3, "Deidre", "Hopkins", -1);

            // can populate these for fun even though they aren't used in this test
            TargetPatient.Addresses = GetAddresses();
            TargetPatient.Contacts = GetContacts();
        }

        /// <summary>
        /// SQLs the command. Allows simple overriding in inherited test
        /// </summary>
        /// <returns></returns>
        public override string SqlCommandText()
        {
            return string.Format("SELECT PatientMasterId FROM hips.PatientMaster  WHERE DateOfBirth = '{0:yyyy-MM-dd}' AND MedicareNumber = '{1}'", TargetPatient.DateOfBirth, TargetPatient.MedicareNumber);
        }

        /// <summary>
        /// Sets the test data.
        /// </summary>
        /// <returns></returns>
        public override int SetTestData()
        {
            ResetPatientData();
            //PatientTestHelpersBase testHelper = new PatientTestHelpersBase();
            GetTestInsertPatient();
            PatientMasterDl patientMasterDl = new PatientMasterDl(GetTestUser());
            bool result = patientMasterDl.Insert(TargetPatient, null);
            if (!result || !TargetPatient.PatientMasterId.HasValue)
            {
                Assert.Fail("The test patient was not saved");
            }
            return TargetPatient.PatientMasterId.Value;
        }

        #endregion Methods Overridden from Base
    }
}