﻿using System.Collections.Generic;
using HIPS.CommonSchemas;
using HIPS.CommonSchemas.PatientIdentifier;
using HIPS.PcehrSchemas;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Test.Helpers;

namespace Test.PcehrBusinessLogic
{
    /// <summary>
    ///This is a test class for ChangeHistoryViewResponseTest and is intended
    ///to contain all ChangeHistoryViewResponseTest Unit Tests
    ///</summary>
    [TestClass()]
    public class ChangeHistoryViewResponseTest
    {
        private TestContext testContextInstance;

        /// <summary>
        ///Gets or sets the test context which provides
        ///information about and functionality for the current test run.
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }

        #region Additional test attributes

        //
        //You can use the following additional attributes as you write your tests:
        //
        //Use ClassInitialize to run code before running the first test in the class
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //Use ClassCleanup to run code after all tests in a class have run
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //Use TestInitialize to run code before running each test
        //[TestInitialize()]
        //public void MyTestInitialize()
        //{
        //}
        //
        //Use TestCleanup to run code after each test has run
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //

        #endregion Additional test attributes

        /// <summary>
        ///A test for ChangeHistoryViewResponse`1 Constructor
        ///</summary>
        public void ChangeHistoryViewResponseConstructorTestHelper<T>()
            where T : PatientIdentifierBase
        {
            ChangeHistoryViewResponse<T> target = new ChangeHistoryViewResponse<T>();
        }

        [TestMethod()]
        public void ChangeHistoryViewResponseConstructorTest()
        {
        }

        /// <summary>
        ///A test for DocumentList
        ///</summary>
        public void DocumentListTestHelper<T>()
            where T : PatientIdentifierBase
        {
            ChangeHistoryViewResponse<T> target = new ChangeHistoryViewResponse<T>();

            IList<DocumentMetaDataItem> expected = new List<DocumentMetaDataItem>();
            expected.Add(DocumentTestHelper.generateTestDocument1());
            IList<DocumentMetaDataItem> actual = null;
            target.DocumentList = expected;
            actual = target.DocumentList;
            Assert.AreEqual(expected, actual);
        }

        [TestMethod()]
        public void DocumentListTest()
        {
            DocumentListTestHelper<StatePatientId>();
            DocumentListTestHelper<PatientMasterId>();
            DocumentListTestHelper<Mrn>();
            DocumentListTestHelper<ValidatedIhi>();
        }

        /// <summary>
        ///A test for HipsResponse
        ///</summary>
        public void HipsResponseTestHelper<T>()
            where T : PatientIdentifierBase
        {
            ChangeHistoryViewResponse<T> target = new ChangeHistoryViewResponse<T>();
            HipsResponse expected = ResponseTestHelper.HipsResponse1(HipsResponseIndicator.OK);
            HipsResponse actual = null;
            target.HipsResponse = expected;
            actual = target.HipsResponse;
            Assert.AreEqual(expected, actual);
        }

        [TestMethod()]
        public void HipsResponseTest()
        {
            HipsResponseTestHelper<StatePatientId>();
            HipsResponseTestHelper<PatientMasterId>();
            HipsResponseTestHelper<Mrn>();
            HipsResponseTestHelper<ValidatedIhi>();
        }

        /// <summary>
        ///A test for IhiNumber
        ///</summary>
        public void IhiNumberTestHelper<T>()
            where T : PatientIdentifierBase
        {
            ChangeHistoryViewResponse<T> target = new ChangeHistoryViewResponse<T>();
            string expected = "1234567891011121";
            string actual = "";
            target.IhiNumber = expected;
            actual = target.IhiNumber;
            Assert.AreEqual(expected, actual);
        }

        [TestMethod()]
        public void IhiNumberTest()
        {
            IhiNumberTestHelper<StatePatientId>();
            IhiNumberTestHelper<PatientMasterId>();
            IhiNumberTestHelper<Mrn>();
            IhiNumberTestHelper<ValidatedIhi>();
        }

        /// <summary>
        ///A test for PatientIdentifier
        ///</summary>
        public void PatientIdentifierTestHelper<T>()
            where T : PatientIdentifierBase
        {
            ChangeHistoryViewResponse<T> target = new ChangeHistoryViewResponse<T>();
            T expected = default(T);
            T actual;
            target.PatientIdentifier = expected;
            actual = target.PatientIdentifier;
            Assert.AreEqual(expected, actual);
        }

        [TestMethod()]
        public void PatientIdentifierTest()
        {
            PatientIdentifierTestHelper<StatePatientId>();
            PatientIdentifierTestHelper<PatientMasterId>();
            PatientIdentifierTestHelper<Mrn>();
            PatientIdentifierTestHelper<ValidatedIhi>();
        }
    }
}