﻿using System;
using HIPS.PcehrSchemas;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Nehta.VendorLibrary.PCEHR;

namespace Test.PcehrBusinessLogic
{
    /// <summary>
    ///This is a test class for DocumentMetaDataItemTest and is intended
    ///to contain all DocumentMetaDataItemTest Unit Tests
    ///</summary>
    [TestClass()]
    public class DocumentMetaDataItemTest
    {
        private TestContext testContextInstance;

        /// <summary>
        ///Gets or sets the test context which provides
        ///information about and functionality for the current test run.
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }

        #region Additional test attributes

        //
        //You can use the following additional attributes as you write your tests:
        //
        //Use ClassInitialize to run code before running the first test in the class
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //Use ClassCleanup to run code after all tests in a class have run
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //Use TestInitialize to run code before running each test
        //[TestInitialize()]
        //public void MyTestInitialize()
        //{
        //}
        //
        //Use TestCleanup to run code after each test has run
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //

        #endregion Additional test attributes

        /// <summary>
        ///A test for DocumentMetaDataItem Constructor
        ///</summary>
        [TestMethod()]
        public void DocumentMetaDataItemConstructorTest()
        {
            DocumentMetaDataItem target = new DocumentMetaDataItem();
        }

        /// <summary>
        ///A test for AuthorInstitution
        ///</summary>
        [TestMethod()]
        public void AuthorInstitutionTest()
        {
            DocumentMetaDataItem target = new DocumentMetaDataItem();
            string expected = "RAH";
            string actual;
            target.AuthorInstitution = expected;
            actual = target.AuthorInstitution;
            Assert.AreEqual(expected, actual);
        }

        /// <summary>
        ///A test for AuthorInstitutionName
        ///</summary>
        [TestMethod()]
        public void AuthorInstitutionNameTest()
        {
            DocumentMetaDataItem target = new DocumentMetaDataItem();
            string expected = "Royal Adelaide Hospital";
            string actual;
            target.AuthorInstitutionName = expected;
            actual = target.AuthorInstitutionName;
            Assert.AreEqual(expected, actual);
        }

        /// <summary>
        ///A test for AuthorPerson
        ///</summary>
        [TestMethod()]
        public void AuthorPersonTest()
        {
            DocumentMetaDataItem target = new DocumentMetaDataItem();
            string expected = "Mr Marcus Garvey";
            string actual;
            target.AuthorPerson = expected;
            actual = target.AuthorPerson;
            Assert.AreEqual(expected, actual);
        }

        /// <summary>
        ///A test for AuthorPersonFamilyName
        ///</summary>
        [TestMethod()]
        public void AuthorPersonFamilyNameTest()
        {
            DocumentMetaDataItem target = new DocumentMetaDataItem();
            string expected = "Garvey";
            string actual;
            target.AuthorPersonFamilyName = expected;
            actual = target.AuthorPersonFamilyName;
            Assert.AreEqual(expected, actual);
        }

        /// <summary>
        ///A test for AuthorPersonGivenName
        ///</summary>
        [TestMethod()]
        public void AuthorPersonGivenNameTest()
        {
            DocumentMetaDataItem target = new DocumentMetaDataItem();
            string expected = "Marcus";
            string actual;
            target.AuthorPersonGivenName = expected;
            actual = target.AuthorPersonGivenName;
            Assert.AreEqual(expected, actual);
        }

        /// <summary>
        ///A test for AuthorPersonNamePrefix
        ///</summary>
        [TestMethod()]
        public void AuthorPersonNamePrefixTest()
        {
            DocumentMetaDataItem target = new DocumentMetaDataItem();
            string expected = "Mr";
            string actual;
            target.AuthorPersonNamePrefix = expected;
            actual = target.AuthorPersonNamePrefix;
            Assert.AreEqual(expected, actual);
        }

        /// <summary>
        ///A test for CreationTime
        ///</summary>
        [TestMethod()]
        public void CreationTimeTest()
        {
            DocumentMetaDataItem target = new DocumentMetaDataItem();
            DateTime expected = DateTime.Now.Date;
            DateTime actual;
            target.CreationTime = expected;
            actual = target.CreationTime;
            Assert.AreEqual(expected, actual);
        }

        /// <summary>
        ///A test for DocumentClassCode
        ///</summary>
        [TestMethod()]
        public void DocumentClassCodeTest()
        {
            DocumentMetaDataItem target = new DocumentMetaDataItem();
            string expected = "18842-5";
            string actual;
            target.DocumentClassCode = expected;
            actual = target.DocumentClassCode;
            Assert.AreEqual(expected, actual);
        }

        /// <summary>
        ///A test for DocumentClassName
        ///</summary>
        [TestMethod()]
        public void DocumentClassNameTest()
        {
            DocumentMetaDataItem target = new DocumentMetaDataItem();
            string expected = "Discharge Summary";
            string actual;
            target.DocumentClassName = expected;
            actual = target.DocumentClassName;
            Assert.AreEqual(expected, actual);
        }

        /// <summary>
        ///A test for DocumentSize
        ///</summary>
        [TestMethod()]
        public void DocumentSizeTest()
        {
            DocumentMetaDataItem target = new DocumentMetaDataItem();
            int expected = 5000;
            int actual;
            target.DocumentSize = expected;
            actual = target.DocumentSize;
            Assert.AreEqual(expected, actual);
        }

        /// <summary>
        ///A test for DocumentStatusCode
        ///</summary>
        [TestMethod()]
        public void DocumentStatusCodeTest()
        {
            DocumentMetaDataItem target = new DocumentMetaDataItem();
            DocumentStatus expected = DocumentStatus.Approved;
            DocumentStatus actual;
            target.DocumentStatusCode = expected;
            actual = target.DocumentStatusCode;
            Assert.AreEqual(expected, actual);
        }

        /// <summary>
        ///A test for DocumentUniqueId
        ///</summary>
        [TestMethod()]
        public void DocumentUniqueIdTest()
        {
            DocumentMetaDataItem target = new DocumentMetaDataItem();
            string expected = "1.2.36.1.2001.1005.26.1.1.45363^12343";
            string actual;
            target.DocumentUniqueId = expected;
            actual = target.DocumentUniqueId;
            Assert.AreEqual(expected, actual);
        }

        /// <summary>
        ///A test for FormatCode
        ///</summary>
        [TestMethod()]
        public void FormatCodeTest()
        {
            DocumentMetaDataItem target = new DocumentMetaDataItem();
            string expected = "1.2.36.1.2001.1006.1.20000.11";
            string actual;
            target.FormatCode = expected;
            actual = target.FormatCode;
            Assert.AreEqual(expected, actual);
        }

        /// <summary>
        ///A test for FormatName
        ///</summary>
        [TestMethod()]
        public void FormatNameTest()
        {
            DocumentMetaDataItem target = new DocumentMetaDataItem();
            string expected = "Discharge Summary - Conformance 3A";
            string actual;
            target.FormatName = expected;
            actual = target.FormatName;
            Assert.AreEqual(expected, actual);
        }

        /// <summary>
        ///A test for Hash
        ///</summary>
        [TestMethod()]
        public void HashTest()
        {
            DocumentMetaDataItem target = new DocumentMetaDataItem();
            string expected = "143eb6a983f93adbc691df1edd8775624cfd41e3";
            string actual;
            target.Hash = expected;
            actual = target.Hash;
            Assert.AreEqual(expected, actual);
        }

        /// <summary>
        ///A test for HealthCareFacilityTypeCode
        ///</summary>
        [TestMethod()]
        public void HealthCareFacilityTypeCodeTest()
        {
            DocumentMetaDataItem target = new DocumentMetaDataItem();
            string expected = "8401";
            string actual;
            target.HealthCareFacilityTypeCode = expected;
            actual = target.HealthCareFacilityTypeCode;
            Assert.AreEqual(expected, actual);
        }

        /// <summary>
        ///A test for HealthCareFacilityTypeName
        ///</summary>
        [TestMethod()]
        public void HealthCareFacilityTypeNameTest()
        {
            DocumentMetaDataItem target = new DocumentMetaDataItem();
            string expected = "Hospitals (except Psychiatric Hospitals)";
            string actual;
            target.HealthCareFacilityTypeName = expected;
            actual = target.HealthCareFacilityTypeName;
            Assert.AreEqual(expected, actual);
        }

        /// <summary>
        ///A test for PracticeSettingTypesCode
        ///</summary>
        [TestMethod()]
        public void PracticeSettingTypesCodeTest()
        {
            DocumentMetaDataItem target = new DocumentMetaDataItem();
            string expected = "8401-5";
            string actual;
            target.PracticeSettingTypesCode = expected;
            actual = target.PracticeSettingTypesCode;
            Assert.AreEqual(expected, actual);
        }

        /// <summary>
        ///A test for PracticeSettingTypesName
        ///</summary>
        [TestMethod()]
        public void PracticeSettingTypesNameTest()
        {
            DocumentMetaDataItem target = new DocumentMetaDataItem();
            string expected = "General Hospital";
            string actual;
            target.PracticeSettingTypesName = expected;
            actual = target.PracticeSettingTypesName;
            Assert.AreEqual(expected, actual);
        }

        /// <summary>
        ///A test for RepositoryUniqueId
        ///</summary>
        [TestMethod()]
        public void RepositoryUniqueIdTest()
        {
            DocumentMetaDataItem target = new DocumentMetaDataItem();
            string expected = "1.2.36.1.2001.1007.10";
            string actual;
            target.RepositoryUniqueId = expected;
            actual = target.RepositoryUniqueId;
            Assert.AreEqual(expected, actual);
        }

        /// <summary>
        ///A test for ServiceStartTime
        ///</summary>
        [TestMethod()]
        public void ServiceStartTimeTest()
        {
            DocumentMetaDataItem target = new DocumentMetaDataItem();
            DateTime expected = DateTime.Now.Date;
            DateTime actual;
            target.ServiceStartTime = expected;
            actual = target.ServiceStartTime;
            Assert.AreEqual(expected, actual);
        }

        /// <summary>
        ///A test for ServiceStopTime
        ///</summary>
        [TestMethod()]
        public void ServiceStopTimeTest()
        {
            DocumentMetaDataItem target = new DocumentMetaDataItem();
            DateTime expected = DateTime.Now.Date;
            DateTime actual;
            target.ServiceStopTime = expected;
            actual = target.ServiceStopTime;
            Assert.AreEqual(expected, actual);
        }
    }
}