﻿using System;
using HIPS.CommonBusinessLogic.Singleton;
using HIPS.CommonSchemas;
using HIPS.PcehrDataStore.DataAccess;
using HIPS.PcehrDataStore.Schemas;
using HIPS.PcehrHiBusinessLogic.Pcehr;
using HIPS.PcehrSchemas;
using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace Test.PcehrBusinessLogic
{
    /// <summary>
    ///This is a test class for DoesPcehrExistTest and is intended
    ///to contain all DoesPcehrExistTest Unit Tests
    ///</summary>
    [TestClass()]
    public class DoesPcehrExistTest
    {
        private TestContext testContextInstance;

        /// <summary>
        ///Gets or sets the test context which provides
        ///information about and functionality for the current test run.
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }

        #region Additional test attributes

        //
        //You can use the following additional attributes as you write your tests:
        //
        //Use ClassInitialize to run code before running the first test in the class
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //Use ClassCleanup to run code after all tests in a class have run
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //Use TestInitialize to run code before running each test
        //[TestInitialize()]
        //public void MyTestInitialize()
        //{
        //}
        //
        //Use TestCleanup to run code after each test has run
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //

        #endregion Additional test attributes

        #region TestMethods

        /// <summary>
        ///A test for PcehrExists
        ///</summary>
        [TestMethod()]
        public void PcehrExistsTest()
        {
            try
            {
                Hospital hospital = HospitalSingleton.Value.Find(22);
                DoesPcehrExist target = new DoesPcehrExist();
                string ihi = "8003608666669130";
                UserDetails user = new UserDetails();
                user.Login = "HAD/SANDEENM";
                user.HpiI = "8003619900000081";
                user.Name = "MILO SANDEEN";
                DoesPcehrExistResponse expected = new DoesPcehrExistResponse();
                expected.PcehrExists = true;
                expected.HipsResponse = new HipsResponse(HipsResponseIndicator.OK);
                DoesPcehrExistResponse actual;

                // This should produce a true result
                PatientMaster patientMaster;
                PatientMasterDl dataAccess = new PatientMasterDl(user);
                dataAccess.GetByIhi(ihi, out patientMaster);
                actual = target.PcehrExists(null, hospital, patientMaster, user);
                RunTests(expected, actual);
                // Switch IHI that should return a false
                ihi = "8003608833338197";
                RunTests(expected, actual);
            }
            catch (Exception ex)
            {
                Assert.Fail(string.Format("Encountered an error {0}", ex.Message));
            }
        }

        private void RunTests(DoesPcehrExistResponse expected, DoesPcehrExistResponse actual)
        {
            if (expected.HipsResponse.Status != actual.HipsResponse.Status)
            {
                Assert.Fail("Expected and Actual status do not match");
            }
            if (expected.PcehrExists != actual.PcehrExists)
            {
                Assert.Fail("PcehrExists expected and actual do not match");
            }
        }

        #endregion TestMethods
    }
}