﻿using System;
using System.IO;
using System.ServiceModel;
using System.Xml;
using HIPS.AppServer.ServiceHost;
using HIPS.Client.Proxy;
using HIPS.CommonSchemas;
using HIPS.CommonSchemas.PatientIdentifier;
using HIPS.PcehrDataStore.DataAccess;
using HIPS.PcehrSchemas;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Test.Helpers;

namespace Test.PcehrBusinessLogic
{
    /// <summary>
    ///This is a test class for PCEHRServiceTest and is intended
    ///to contain all PCEHRServiceTest Unit Tests
    ///</summary>
    [TestClass()]
    public class PCEHRServiceTest : PatientTestHelpersBase
    {
        #region Private Members

        private TestContext testContextInstance;
        private long timeStamp;
        private UserDetails defaultUser;

        #endregion Private Members

        #region Properties

        /// <summary>
        ///Gets or sets the test context which provides
        ///information about and functionality for the current test run.
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }

        #endregion Properties

        #region Additional test attributes

        //
        //You can use the following additional attributes as you write your tests:
        //
        //Use ClassInitialize to run code before running the first test in the class
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //Use ClassCleanup to run code after all tests in a class have run
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //Use TestInitialize to run code before running each test
        //[TestInitialize()]
        //public void MyTestInitialize()
        //{
        //}
        //
        //Use TestCleanup to run code after each test has run
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //

        #endregion Additional test attributes

        #region Constructor

        public PCEHRServiceTest()
        {
            defaultUser = new UserDetails();
            defaultUser.Login = "GMASSE01";
            defaultUser.IsContractedServiceProvider = false;
            defaultUser.Name = "Gordon Massey";
            defaultUser.Domain = "HAD";
            defaultUser.Role = UserRole.InteractiveUser;

            //set the time stamp - using this for a quick and dirty unique id

            DateTime centuryBegin = new DateTime(2012, 1, 1);
            DateTime currentDate = DateTime.Now;
            long elapsedTicks = currentDate.Ticks - centuryBegin.Ticks;
            TimeSpan elapsedSpan = new TimeSpan(elapsedTicks);
            string ts = string.Format("{0:F0}", elapsedSpan.TotalMinutes);
            this.timeStamp = Convert.ToInt64(ts);
        }

        #endregion Constructor

        #region Methods Overriden from Base

        /// <summary>
        /// Gets the insert patient.
        /// </summary>
        override public void GetTestInsertPatient()
        {
            //PatientMaster result = new PatientMaster();
            TargetPatient.CurrentSexId = 1;
            TargetPatient.DateOfBirth = new DateTime(1940, 6, 8);
            TargetPatient.SetNewCurrentName(3, "Berman", "JAKE F", -1);

            // can populate these for fun even though they aren't used in this test
            TargetPatient.Addresses = GetAddresses();
            TargetPatient.Contacts = GetContacts();
        }

        /// <summary>
        /// Sets the test data.
        /// </summary>
        /// <returns></returns>
        public override int SetTestData()
        {
            ResetPatientData();
            //PatientTestHelpersBase testHelper = new PatientTestHelpersBase();
            GetTestInsertPatient();
            PatientMasterDl patientMasterDl = new PatientMasterDl(GetTestUser());
            bool result = patientMasterDl.Insert(TargetPatient, null);
            if (!result || !TargetPatient.PatientMasterId.HasValue)
            {
                Assert.Fail("The test patient was not saved");
            }
            return TargetPatient.PatientMasterId.Value;
        }

        #endregion Methods Overriden from Base

        /// <summary>
        ///A test for UploadOrSupersede
        ///</summary>
        [TestMethod()]
        public void UploadOrSupersedeTest()
        {
            //PCEHRService target = new PCEHRService();

            // This guarantees a new document for PCEHR
            byte[] cdaDocument = GetCdaDocument();

            //TODO: Populate mrn in database
            //string mrn = "TEST-"+this.timeStamp; // TODO: Initialize to an appropriate value
            Mrn mrnIdentifier = new Mrn("TEST-GM_03", "BER", "pasFacCd");

            Attachment[] attachments = null; // TODO: Initialize to an appropriate value
            DateTime admissionDate = new DateTime(2012, 11, 29);  // TODO: Initialize to an appropriate value

            //string expected = string.Empty; // TODO: Initialize to an appropriate value
            HipsResponse actual;

            //actual = target.UploadOrSupersedeDocument(cdaDocument, mrnIdentifier, defaultUser, attachments, admissionDate);

            using (PCEHRProxy proxy = new PCEHRProxy("PcehrEndPoint"))
            {
                try
                {
                    actual = proxy.UploadOrSupersedeDocument(cdaDocument, mrnIdentifier, defaultUser, attachments, admissionDate);
                }
                catch (EndpointNotFoundException ex)
                {
                    proxy.Abort();
                    throw new Exception("Connection could not be established", ex);
                }
                catch (Exception e)
                {
                    proxy.Abort();
                    throw e;
                }
            }

            if (actual.Status != HipsResponseIndicator.OK)
            {
                Assert.Fail("{0}", actual);
            }
        }

        /// <summary>
        /// Gets the cda document.
        /// </summary>
        /// <returns></returns>
        private byte[] GetCdaDocument()
        {
            // set the Id to something unique
            string cdaDoc = "";
            try
            {
                using (StringReader stream = new StringReader(TestResources.RouteCodeRemoved))
                {
                    XmlDocument xmlDoc = new XmlDocument();
                    xmlDoc.Load(stream);
                    XmlNamespaceManager xnm = new XmlNamespaceManager(new NameTable());
                    xnm.AddNamespace("x", "urn:hl7-org:v3");
                    XmlNode node = xmlDoc.SelectSingleNode("//x:id", xnm);
                    string id = node.Attributes["root"].Value;
                    string extension = this.timeStamp.ToString();
                    char[] delimiterChars = { '.' };
                    string[] words = id.Split(delimiterChars);
                    words[words.Length - 1] = extension;
                    id = String.Join(".", words);

                    node.Attributes["root"].InnerText = id;
                    node.Attributes["extension"].InnerText = extension;
                    cdaDoc = xmlDoc.InnerXml;
                }

                //
            }
            catch (Exception ex)
            {
                Assert.Fail("Problem with CDA document: {0}", ex.Message);
            }
            System.Text.UTF8Encoding encoding = new System.Text.UTF8Encoding();

            return encoding.GetBytes(cdaDoc);
        }

        [TestMethod()]
        public void UploadOrSupersedeTestActualUser()
        {
            PCEHRService target = new PCEHRService();
            byte[] cdaDocument;

            System.Text.UTF8Encoding encoding = new System.Text.UTF8Encoding();
            cdaDocument = encoding.GetBytes(TestResources.RouteCodeRemoved);
            Mrn mrn = new Mrn("TEST-GM_01", "BER", "pasFacCd"); // TODO: Initialize to an appropriate value
            UserDetails defaultUser = new UserDetails();
            defaultUser.Login = "GMASSE01";
            defaultUser.IsContractedServiceProvider = false;
            defaultUser.Name = "Gordon Massey";
            defaultUser.Domain = "HAD";

            defaultUser.Role = UserRole.InteractiveUser;

            Attachment[] attachments = null; // TODO: Initialize to an appropriate value
            DateTime admissionDate = new DateTime(2012, 11, 15);  // TODO: Initialize to an appropriate value

            //string expected = string.Empty; // TODO: Initialize to an appropriate value
            HipsResponse actual;
            actual = target.UploadOrSupersedeDocument(cdaDocument, mrn, defaultUser, attachments, admissionDate);
            if (actual.Status != HipsResponseIndicator.OK)
            {
                Assert.Fail("{0}", actual);
            }
        }
    }
}