﻿using HIPS.PcehrDataStore.Schemas;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Test.CommonCcaNoc.Helpers;

namespace Test.PcehrCcaNoc.ClinicalInformationSystem.UC_CIS_201
{
    /// <summary>
    /// Conformance Test Specification: Clinical Information Systems
    ///                                 Connecting to the PCEHR System
    ///                                 Version 1.6 — 27 September 2012
    /// Use Case #:	    UC.CIS.201
    /// Use Case Name:	Upload a Clinical Document
    /// Test Case ID:   PCEHR_CIS_017841a
    /// Objective:
    /// To check that the clinical information either retains any clinical
    /// document uploaded to the PCEHR System, or retains the original
    /// clinical information used to generate the clinical document uploaded
    /// to the PCEHR.
    /// </summary>
    [TestClass]
    public class PCEHR_CIS_017841a : CcaTest
    {
        /// <summary>
        /// Create a clinical document for a healthcare recipient using the
        /// software, and upload the clinical document to the PCEHR System:
        /// Verify that the software system fulfils either criteria a or b:
        /// a. Retains the clinical information used to create the clinical
        ///    documents locally.
        /// b. Retains a copy of the clinical document that was uploaded.
        ///
        /// In this implementation, we demonstrate that HIPS retains a copy
        /// of the document.
        /// If that gets changed then this conformance requirement will need
        /// to be handled in another part of the CIS.
        /// </summary>
        [TestMethod]
        [TestCategory("CIS_CCA_201")]
        public void CIS_201_017841a_B()
        {
            patient = CcaPatient.GetPatient(ihiValid: true, validatedWithinPeriod: true, hasUnresolvedAlerts: false, testDataId: "CCA ID IHI_85");
            Episode episode = patient.TargetEpisode;
            CdaDocument cdaDocument = patient.CreateNewDocument(SampleDocumentType.DischargeSummary);
            QueueHelper.UploadDocumentAndWaitUntilProcessed(patient, LogAssert, cdaDocument);

            // Demonstrate criteria B, that the document is retained in the hips.ClinicalDocumentVersion table.
            ClinicalDocumentVersion version = patient.GetLastClinicalDocumentVersion();
            LogAssert.AreEqual(cdaDocument.GetDocId(), version.SourceSystemDocumentId, DialogueResource.UploadedDocumentDocumentId);
            byte[] actualContent = CdaPackage.ExtractDocument(version.Package);

            //This will no longer be true because HIPS added the integrity check attribute to the logo.
            //CollectionAssert.AreEqual(cdaDocument.GetBytes(), actualContent);
        }
    }
}