﻿using System.Text;
using HIPS.CommonSchemas;
using HIPS.PcehrDataStore.Schemas;
using HIPS.PcehrSchemas;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Test.CommonCcaNoc.Helpers;

namespace Test.PcehrCcaNoc.ClinicalInformationSystem.UC_CIS_201
{
    /// <summary>
    /// Conformance Test Specification: Clinical Information Systems Connecting to the PCEHR System
    ///                                 Version 1.6 — 27 September 2012
    /// Use Case #:	    UC.CIS.201
    /// Use Case Name:	Upload a Clinical Document
    /// Test Case ID:   PCEHR_CIS_019042
    /// Objective:
    /// To check that the CIS provides the ability to support withdrawal of
    /// consent to upload clinical documents to the PCEHR, and to check that
    /// they are prevented from being uploaded where consent has been withdrawn.
    /// </summary>
    [TestClass]
    public class PCEHR_CIS_019042 : CcaTest
    {
        /// <summary>
        /// Withdraw consent either before or after creating a clinical document
        /// for a healthcare recipient:
        /// a. Verify the software provides the ability to withdraw consent to
        ///    upload the document to the PCEHR System.
        /// b. Verify that the document is not uploaded to the PCEHR system.
        /// </summary>
        [TestMethod]
        [TestCategory("CIS_CCA_201")]
        public void CIS_201_019042_AB()
        {
            // Create the document
            patient = CcaPatient.GetPatient(ihiValid: true, validatedWithinPeriod: true, hasUnresolvedAlerts: false, testDataId: "CCA ID IHI_85");
            Episode episode = patient.TargetEpisode;
            CdaDocument cdaDocument = patient.CreateNewDocument(SampleDocumentType.DischargeSummary);

            // Call the HIPS service to withdraw consent, check the response is OK.
            byte[] auditInformation = Encoding.UTF8.GetBytes("CIS_201_019042_AB");
            HipsResponse consentResponse = ProxyHelper.ConsentProxy.RecordConsent(true, patient.TargetPatientIdentifier, episode.AdmissionDate, patient.GetTestUser(), auditInformation);
            LogAssert.ExpectResponse(HipsResponseIndicator.OK, consentResponse, DialogueResource.HipsServiceRecordConsent);

            // Call the HIPS service to upload the document, check that the response is that the upload cannot proceed because consent was withdrawn.
            HipsResponse uploadResponse = ProxyHelper.PcehrProxy.UploadOrSupersedeDocument(
                cdaDocument.GetBytes(), patient.TargetPatientIdentifier, patient.GetTestUser(),
                new Attachment[0], episode.AdmissionDate, cdaDocument.GetFormatCode());
            LogAssert.ExpectResponse(HipsResponseIndicator.ConsentWithdrawn, uploadResponse, DialogueResource.HipsServiceUploadDocument);

            // Call the HIPS service to verify that the document was not uploaded.
            OperationStatus statusResponse = ProxyHelper.PcehrProxy.GetOperationStatus(patient.TargetPatientIdentifier, episode.AdmissionDate, patient.GetTestUser());
            LogAssert.ExpectResponse(HipsResponseIndicator.OK, statusResponse.Response, DialogueResource.HipsServiceGetOperationStatus);
            LogAssert.AreEqual(0, statusResponse.QueuedOperations.Count, DialogueResource.QueuedOperationsCount);
            LogAssert.AreEqual(0, statusResponse.UploadedDocuments.Count, DialogueResource.UploadedDocumentsCount);
        }
    }
}