﻿using Microsoft.VisualStudio.TestTools.UnitTesting;
using Test.CommonCcaNoc.Helpers;

namespace Test.PcehrCcaNoc.ClinicalInformationSystem.UC_CIS_202
{
    /// <summary>
    /// Conformance Test Specification: Clinical Information Systems
    ///                                 Connecting to the PCEHR System
    ///                                 Version 1.6 — 27 September 2012
    /// Use Case #:	    UC.CIS.202
    /// Use Case Name:	Supersede a Clinical Document
    /// Test Case ID:   PCEHR_CIS_018338
    /// Objective:
    /// To check that the Clinical Information System provides an ability to
    /// supersede previously uploaded clinical documents where there is a
    /// change or an error in the data used to create the uploaded clinical
    /// documents.
    /// </summary>
    [TestClass]
    public class PCEHR_CIS_018338 : CcaTest
    {
        /// <summary>
        /// If the software supports the uploading of clinical document types
        /// other than Shared Health Summary, create a clinical document other
        /// than Shared Health Summary for a healthcare recipient using the
        /// software, and perform the following steps:
        /// 1. Upload the document to the PCEHR System.
        /// 2. Create an amended version of the uploaded document.
        /// 3. Supersede the uploaded version on the PCEHR System with the amended version.
        /// Now:
        /// a. Verify that steps 1 - 3 above can be performed without error.
        /// </summary>
        [TestMethod]
        [TestCategory("CIS_CCA_202")]
        public void CIS_202_018338_A()
        {
            patient = CcaPatient.GetPatient(ihiValid: true, validatedWithinPeriod: true, hasUnresolvedAlerts: false, testDataId: "CCA ID IHI_85");
            CdaDocument cdaDocument1 = patient.CreateNewDocument(SampleDocumentType.DischargeSummary);

            // Step 1
            QueueHelper.UploadDocumentAndWaitUntilProcessed(patient, LogAssert, cdaDocument1);

            // Step 2
            CdaDocument cdaDocument2 = patient.CreateNewDocument(SampleDocumentType.DischargeSummary);

            // Step 3
            QueueHelper.UploadDocumentAndWaitUntilProcessed(patient, LogAssert, cdaDocument2);
        }
    }
}