﻿using System.Text;
using HIPS.CommonSchemas;
using HIPS.PcehrDataStore.Schemas;
using HIPS.PcehrDataStore.Schemas.Enumerators;
using HIPS.PcehrSchemas;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Test.CommonCcaNoc.Helpers;

namespace Test.PcehrCcaNoc.ClinicalInformationSystem.UC_CIS_203
{
    /// <summary>
    /// Conformance Test Specification: Clinical Information Systems Connecting to the PCEHR System
    ///                                 Version 1.6 — 27 September 2012
    /// Use Case #:	    UC.CIS.203
    /// Use Case Name:	Remove a Clinical Document
    /// Test Case ID:   PCEHR_CIS_019378
    /// Objective:
    /// To check there is a capability to create audit logs for interactions with the PCEHR System.
    /// </summary>
    [TestClass]
    public class PCEHR_CIS_019378 : CcaTest
    {
        /// <summary>
        /// Perform an operation to invoke removeDocument service on the PCEHR System.
        /// a. Demonstrate that an audit capability exists.
        /// </summary>
        [TestMethod]
        [TestCategory("CIS_CCA_203")]
        public void CIS_203_019378_A()
        {
            // Create and upload the initial version of the document
            patient = CcaPatient.GetPatient(ihiValid: true, validatedWithinPeriod: false, hasUnresolvedAlerts: false);
            CdaDocument cdaDocument = patient.CreateNewDocument(SampleDocumentType.DischargeSummary);
            QueueHelper.UploadDocumentAndWaitUntilProcessed(patient, LogAssert, cdaDocument);

            // Perform an operation to remove the document from the PCEHR System.
            byte[] auditInformation = Encoding.UTF8.GetBytes("CIS_203_019378_A");
            HipsResponse response = ProxyHelper.PcehrProxy.Remove(patient.TargetPatientIdentifier, patient.TargetEpisode.AdmissionDate, cdaDocument.GetSetId(), RemovalReason.Withdrawn, patient.GetTestUser(), auditInformation);
            LogAssert.ExpectResponse(HipsResponseIndicator.OK, response, DialogueResource.HipsServiceRemove);
            QueueHelper.WaitForQueuedOperation(patient, LogAssert, DialogueResource.RemoveWaitTimeout);

            // Check that the PCEHR remove document service invocation was audited
            PcehrAudit audit = patient.GetLastPcehrAudit();
            LogAssert.AreEqual(patient.TargetPatientMasterId, audit.PatientMasterId, DialogueResource.PcehrAuditPatientMasterId);
            LogAssert.AreEqual(AuditOperationNames.RemoveDocument, audit.ServiceName, DialogueResource.PcehrAuditServiceName);
        }
    }
}