


-- Add rows to [hips].[Hospital]
SET IDENTITY_INSERT [hips].[Hospital] ON
INSERT INTO [hips].[Hospital] ([HospitalId], [Description], [Name], [HealthProviderOrganisationId], [AuthorisedEmployeeName], [AuthorisedEmployeeUserId], [UploadDocumentMinimumAge], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (1, 'HIPS Hospital Description', 'HIPS Hospital', 1, 'Authorised Employee Name', 'AEUID', 0, '2012-03-28 09:57:59.343', 'HIPS', '2012-07-25 12:58:00.000', 'HIPS')
SET IDENTITY_INSERT [hips].[Hospital] OFF

-- Add rows to [hips].[Address]
SET IDENTITY_INSERT [hips].[Address] ON
INSERT INTO [hips].[Address] ([AddressId], [AddressLine1], [AddressLine2], [PlaceName], [AustralianStateId], [InternationalStateCode], [Postcode], [CountryId], [AddressTypeId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (1, '1 Medical Road', NULL, 'Place Name', 1, NULL, '5000', 71, 4, '2012-12-12 00:00:00.000', 'HIPS', '2012-12-12 00:00:00.000', 'HIPS')
SET IDENTITY_INSERT [hips].[Address] OFF

-- Add rows to [hips].[Contact]
SET IDENTITY_INSERT [hips].[Contact] ON
--BOTH Main Phone and Fax are required
--main phone number
INSERT INTO [hips].[Contact] ([ContactId], [Detail], [ContactMethodId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (1, '(08) 8888 6666', 6, '2012-10-17 09:21:18.677', 'HIPS', '2012-10-17 09:21:18.677', 'HIPS')
--fax number
INSERT INTO [hips].[Contact] ([ContactId], [Detail], [ContactMethodId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (2, '(08) 8888 7777', 7, '2012-10-17 09:21:18.677', 'HIPS', '2012-10-17 09:21:18.677', 'HIPS')
SET IDENTITY_INSERT [hips].[Contact] OFF

-- Add rows to [hips].[HospitalAddress]
INSERT INTO [hips].[HospitalAddress] ([HospitalId], [AddressId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (1, 1, '2012-10-17 09:17:10.360', 'HIPS', '2012-10-17 09:17:10.360', 'HIPS')

-- Add rows to [hips].[HospitalContact]
INSERT INTO [hips].[HospitalContact] ([HospitalId], [ContactId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (1, 1, '2012-10-17 09:23:27.583', 'HIPS', '2012-10-17 09:23:27.583', 'HIPS')
INSERT INTO [hips].[HospitalContact] ([HospitalId], [ContactId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (1, 2, '2012-10-17 09:23:27.583', 'HIPS', '2012-10-17 09:23:27.583', 'HIPS')


-- Add rows to [hips].[HospitalCode]
INSERT INTO [hips].[HospitalCode] ([HospitalId], [CodeSystemId], [Code], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (1, 2, '*HOSPITAL-CODE*', '2012-10-17 10:20:19.623', 'HIPS', '2012-10-17 10:20:19.623', 'HIPS')
INSERT INTO [hips].[HospitalCode] ([HospitalId], [CodeSystemId], [Code], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (1, 5, '1.2.36.1.2001.1005.14.1078.55', '2012-10-17 10:20:19.623', 'HIPS', '2012-10-17 10:20:19.623', 'HIPS')
INSERT INTO [hips].[HospitalCode] ([HospitalId], [CodeSystemId], [Code], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (1, 6, '1.2.36.1.2001.1005.14.660.55', '2012-10-17 10:20:19.623', 'HIPS', '2012-10-17 10:20:19.623', 'HIPS')
INSERT INTO [hips].[HospitalCode] ([HospitalId], [CodeSystemId], [Code], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (1, 7, '0055', '2012-10-17 10:20:19.623', 'HIPS', '2012-10-17 10:20:19.623', 'HIPS')

