DROP TRIGGER hips.HospitalPatientUTrg
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Simon Biber
-- Create date:   20 June 2013
-- Description:   Inserts the history record when the hospital patient is updated
-- =============================================
CREATE TRIGGER hips.HospitalPatientUTrg
ON hips.HospitalPatient
FOR UPDATE AS
BEGIN

SET NOCOUNT ON

INSERT hips.HospitalPatientHistory
       ([HospitalPatientId]
       ,[FromPatientMasterId]
       ,[ToPatientMasterId]
       ,[HospitalId]
       ,[FromMrn]
       ,[ToMrn]
       ,[DateCreated]
       ,[UserCreated]
       ,[DateModified]
       ,[UserModified])
SELECT	  inserted.PatientId
		, deleted.PatientMasterId
		, inserted.PatientMasterId
		, inserted.HospitalId
		, deleted.Mrn
		, inserted.Mrn
		, inserted.DateModified
		, inserted.UserModified
		, inserted.DateModified
		, inserted.UserModified
FROM deleted
INNER JOIN inserted ON inserted.PatientId = deleted.PatientId
WHERE	(inserted.PatientMasterId <> deleted.PatientMasterId
	OR	inserted.Mrn <> deleted.Mrn)

END
GO

