DROP TRIGGER hips.PatientMasterUTrg
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Simon Biber
-- Create date:   20 June 2013
-- Description:   Inserts the history record when the patient master is updated
-- =============================================
CREATE TRIGGER hips.PatientMasterUTrg
ON hips.PatientMaster
FOR UPDATE AS
BEGIN

SET NOCOUNT ON

INSERT hips.PatientMasterHistory
		   ([PatientMasterId]
           ,[FromStatePatientId]
           ,[ToStatePatientId]
           ,[DateCreated]
           ,[UserCreated]
           ,[DateModified]
           ,[UserModified])
SELECT	  inserted.PatientMasterId
		, deleted.StatePatientId
		, inserted.StatePatientId
		, inserted.DateModified
		, inserted.UserModified
		, inserted.DateModified
		, inserted.UserModified
FROM deleted
INNER JOIN inserted ON inserted.PatientMasterId = deleted.PatientMasterId
WHERE	(inserted.StatePatientId <> deleted.StatePatientId)
OR		(inserted.StatePatientId IS NULL AND deleted.StatePatientId IS NOT NULL)
OR		(inserted.StatePatientId IS NOT NULL AND deleted.StatePatientId IS NULL)

END
GO

