SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[Address]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[Address](
	[AddressId] [int] IDENTITY(1,1) NOT NULL,
	[AddressLine1] [varchar](100) NOT NULL,
	[AddressLine2] [varchar](100) NULL,
	[PlaceName] [varchar](100) NULL,
	[AustralianStateId] [int] NOT NULL,
	[InternationalStateCode] [varchar](10) NULL,
	[Postcode] [varchar](10) NULL,
	[CountryId] [int] NOT NULL,
	[AddressTypeId] [int] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_Address] PRIMARY KEY CLUSTERED 
(
	[AddressId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'Address', N'COLUMN',N'AddressLine1'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'First line of unstructured address' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'Address', @level2type=N'COLUMN',@level2name=N'AddressLine1'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'Address', N'COLUMN',N'AddressLine2'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Second line of unstructured address' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'Address', @level2type=N'COLUMN',@level2name=N'AddressLine2'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'Address', N'COLUMN',N'PlaceName'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Suburb, Town or Locality' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'Address', @level2type=N'COLUMN',@level2name=N'PlaceName'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'Address', N'COLUMN',N'AustralianStateId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'For Australian address, identifies the state.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'Address', @level2type=N'COLUMN',@level2name=N'AustralianStateId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'Address', N'COLUMN',N'InternationalStateCode'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'For international address, identifies the state or province.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'Address', @level2type=N'COLUMN',@level2name=N'InternationalStateCode'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'Address', N'COLUMN',N'Postcode'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'For Australian address, the postcode. For international, the postal or ZIP code.
' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'Address', @level2type=N'COLUMN',@level2name=N'Postcode'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'Address', N'COLUMN',N'CountryId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'For both australian and international address, identifies the country.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'Address', @level2type=N'COLUMN',@level2name=N'CountryId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'Address', N'COLUMN',N'AddressTypeId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies the address type.
' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'Address', @level2type=N'COLUMN',@level2name=N'AddressTypeId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'Address', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A physical address for a single patient or hospital. Records must never be shared between patients.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'Address'
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_Address_AddressType]') AND parent_object_id = OBJECT_ID(N'[hips].[Address]'))
ALTER TABLE [hips].[Address]  WITH CHECK ADD  CONSTRAINT [FK_Address_AddressType] FOREIGN KEY([AddressTypeId])
REFERENCES [hips].[AddressType] ([AddressTypeId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_Address_AddressType]') AND parent_object_id = OBJECT_ID(N'[hips].[Address]'))
ALTER TABLE [hips].[Address] CHECK CONSTRAINT [FK_Address_AddressType]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_Address_Country]') AND parent_object_id = OBJECT_ID(N'[hips].[Address]'))
ALTER TABLE [hips].[Address]  WITH CHECK ADD  CONSTRAINT [FK_Address_Country] FOREIGN KEY([CountryId])
REFERENCES [hips].[Country] ([CountryId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_Address_Country]') AND parent_object_id = OBJECT_ID(N'[hips].[Address]'))
ALTER TABLE [hips].[Address] CHECK CONSTRAINT [FK_Address_Country]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_Address_State]') AND parent_object_id = OBJECT_ID(N'[hips].[Address]'))
ALTER TABLE [hips].[Address]  WITH CHECK ADD  CONSTRAINT [FK_Address_State] FOREIGN KEY([AustralianStateId])
REFERENCES [hips].[State] ([StateId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_Address_State]') AND parent_object_id = OBJECT_ID(N'[hips].[Address]'))
ALTER TABLE [hips].[Address] CHECK CONSTRAINT [FK_Address_State]
GO

