SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[ClinicalDocument]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[ClinicalDocument](
	[ClinicalDocumentId] [int] IDENTITY(1,1) NOT NULL,
	[SourceSystemSetId] [varchar](128) NOT NULL,
	[EpisodeId] [int] NOT NULL,
	[DocumentTypeId] [int] NOT NULL,
	[ClinicalDocumentStatusId] [int] NOT NULL,
	[RemovedDate] [datetime] NULL,
	[RemovalReasonId] [int] NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_ClinicalDocument] PRIMARY KEY CLUSTERED 
(
	[ClinicalDocumentId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'ClinicalDocument', N'COLUMN',N'SourceSystemSetId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A globally-unique identifier for the clinical document, shared by different versions of the same document. Can be a UUID, or an OID, or an OID^extension.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'ClinicalDocument', @level2type=N'COLUMN',@level2name=N'SourceSystemSetId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'ClinicalDocument', N'COLUMN',N'EpisodeId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The episode that this document relates to.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'ClinicalDocument', @level2type=N'COLUMN',@level2name=N'EpisodeId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'ClinicalDocument', N'COLUMN',N'DocumentTypeId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Which type of clinical document this is.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'ClinicalDocument', @level2type=N'COLUMN',@level2name=N'DocumentTypeId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'ClinicalDocument', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A locally-created clinical document' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'ClinicalDocument'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'ClinicalDocument', N'COLUMN',N'RemovedDate'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The date and time when this document was removed' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'ClinicalDocument', @level2type=N'COLUMN',@level2name=N'RemovedDate'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'ClinicalDocument', N'COLUMN',N'RemovalReasonId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The reason that this document was removed' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'ClinicalDocument', @level2type=N'COLUMN',@level2name=N'RemovalReasonId'
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_ClinicalDocument_DocumentType]') AND parent_object_id = OBJECT_ID(N'[hips].[ClinicalDocument]'))
ALTER TABLE [hips].[ClinicalDocument]  WITH CHECK ADD  CONSTRAINT [FK_ClinicalDocument_DocumentType] FOREIGN KEY([DocumentTypeId])
REFERENCES [hips].[DocumentType] ([DocumentTypeId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_ClinicalDocument_DocumentType]') AND parent_object_id = OBJECT_ID(N'[hips].[ClinicalDocument]'))
ALTER TABLE [hips].[ClinicalDocument] CHECK CONSTRAINT [FK_ClinicalDocument_DocumentType]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_ClinicalDocument_Episode]') AND parent_object_id = OBJECT_ID(N'[hips].[ClinicalDocument]'))
ALTER TABLE [hips].[ClinicalDocument]  WITH CHECK ADD  CONSTRAINT [FK_ClinicalDocument_Episode] FOREIGN KEY([EpisodeId])
REFERENCES [hips].[Episode] ([EpisodeId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_ClinicalDocument_Episode]') AND parent_object_id = OBJECT_ID(N'[hips].[ClinicalDocument]'))
ALTER TABLE [hips].[ClinicalDocument] CHECK CONSTRAINT [FK_ClinicalDocument_Episode]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_ClinicalDocument_RemovalReason]') AND parent_object_id = OBJECT_ID(N'[hips].[ClinicalDocument]'))
ALTER TABLE [hips].[ClinicalDocument]  WITH CHECK ADD  CONSTRAINT [FK_ClinicalDocument_RemovalReason] FOREIGN KEY([RemovalReasonId])
REFERENCES [hips].[RemovalReason] ([RemovalReasonId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_ClinicalDocument_RemovalReason]') AND parent_object_id = OBJECT_ID(N'[hips].[ClinicalDocument]'))
ALTER TABLE [hips].[ClinicalDocument] CHECK CONSTRAINT [FK_ClinicalDocument_RemovalReason]
GO

