SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[ClinicalDocumentVersion]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[ClinicalDocumentVersion](
	[ClinicalDocumentVersionId] [int] IDENTITY(1,1) NOT NULL,
	[ClinicalDocumentId] [int] NOT NULL,
	[SourceSystemDocumentId] [varchar](128) NOT NULL,
	[UploadedDate] [datetime] NULL,
	[SupersededDate] [datetime] NULL,
	[Package] [varbinary](max) NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_ClinicalDocumentVersion] PRIMARY KEY CLUSTERED 
(
	[ClinicalDocumentVersionId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'ClinicalDocumentVersion', N'COLUMN',N'ClinicalDocumentId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The document that this is a version of' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'ClinicalDocumentVersion', @level2type=N'COLUMN',@level2name=N'ClinicalDocumentId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'ClinicalDocumentVersion', N'COLUMN',N'SourceSystemDocumentId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A globally-unique identifier for this version of the clinical document. Can be a UUID, or an OID, or an OID^extension.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'ClinicalDocumentVersion', @level2type=N'COLUMN',@level2name=N'SourceSystemDocumentId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'ClinicalDocumentVersion', N'COLUMN',N'UploadedDate'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The date and time when this version was uploaded' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'ClinicalDocumentVersion', @level2type=N'COLUMN',@level2name=N'UploadedDate'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'ClinicalDocumentVersion', N'COLUMN',N'SupersededDate'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The date and time when this version was superseded' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'ClinicalDocumentVersion', @level2type=N'COLUMN',@level2name=N'SupersededDate'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'ClinicalDocumentVersion', N'COLUMN',N'Package'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The CDA package is stored here if the source requests it to be' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'ClinicalDocumentVersion', @level2type=N'COLUMN',@level2name=N'Package'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'ClinicalDocumentVersion', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Versions of locally-created clinical documents' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'ClinicalDocumentVersion'
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_ClinicalDocumentVersion_ClinicalDocument]') AND parent_object_id = OBJECT_ID(N'[hips].[ClinicalDocumentVersion]'))
ALTER TABLE [hips].[ClinicalDocumentVersion]  WITH CHECK ADD  CONSTRAINT [FK_ClinicalDocumentVersion_ClinicalDocument] FOREIGN KEY([ClinicalDocumentId])
REFERENCES [hips].[ClinicalDocument] ([ClinicalDocumentId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_ClinicalDocumentVersion_ClinicalDocument]') AND parent_object_id = OBJECT_ID(N'[hips].[ClinicalDocumentVersion]'))
ALTER TABLE [hips].[ClinicalDocumentVersion] CHECK CONSTRAINT [FK_ClinicalDocumentVersion_ClinicalDocument]
GO

