SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[ConsentAudit]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[ConsentAudit](
	[ConsentAuditId] [int] IDENTITY(1,1) NOT NULL,
	[EpisodeId] [int] NOT NULL,
	[ConsentWithdrawn] [bit] NOT NULL,
	[AuditInformation] [varbinary](MAX) NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_ConsentAudit] PRIMARY KEY CLUSTERED 
(
	[ConsentAuditId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'ConsentAudit', N'COLUMN',N'ConsentAuditId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Primary Key' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'ConsentAudit', @level2type=N'COLUMN',@level2name=N'ConsentAuditId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'ConsentAudit', N'COLUMN',N'EpisodeId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Link to the episode for which consent was modified' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'ConsentAudit', @level2type=N'COLUMN',@level2name=N'EpisodeId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'ConsentAudit', N'COLUMN',N'ConsentWithdrawn'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'New value of the consent flag' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'ConsentAudit', @level2type=N'COLUMN',@level2name=N'ConsentWithdrawn'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'ConsentAudit', N'COLUMN',N'AuditInformation'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The form requesting the change' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'ConsentAudit', @level2type=N'COLUMN',@level2name=N'AuditInformation'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'ConsentAudit', N'COLUMN',N'DateCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date that this record was inserted into the table' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'ConsentAudit', @level2type=N'COLUMN',@level2name=N'DateCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'ConsentAudit', N'COLUMN',N'UserCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User account that inserted the record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'ConsentAudit', @level2type=N'COLUMN',@level2name=N'UserCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'ConsentAudit', N'COLUMN',N'DateModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date and time that this record was last modified (or as inserted)' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'ConsentAudit', @level2type=N'COLUMN',@level2name=N'DateModified'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'ConsentAudit', N'COLUMN',N'UserModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The account of the user that last modified (or inserted) this record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'ConsentAudit', @level2type=N'COLUMN',@level2name=N'UserModified'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'ConsentAudit', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Record that a user made a change to the patient''s consent to upload documents to the PCEHR for a particular episode.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'ConsentAudit'
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_ConsentAudit_Episode]') AND parent_object_id = OBJECT_ID(N'[hips].[ConsentAudit]'))
ALTER TABLE [hips].[ConsentAudit]  WITH CHECK ADD  CONSTRAINT [FK_ConsentAudit_Episode] FOREIGN KEY([EpisodeId])
REFERENCES [hips].[Episode] ([EpisodeId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_ConsentAudit_Episode]') AND parent_object_id = OBJECT_ID(N'[hips].[ConsentAudit]'))
ALTER TABLE [hips].[ConsentAudit] CHECK CONSTRAINT [FK_ConsentAudit_Episode]
GO

