SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[Contact]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[Contact](
	[ContactId] [int] IDENTITY(1,1) NOT NULL,
	[Detail] [varchar](256) NOT NULL,
	[ContactMethodId] [int] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_Contact] PRIMARY KEY CLUSTERED 
(
	[ContactId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'Contact', N'COLUMN',N'Detail'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Contact number or address (e.g. joe.blogs@email.com or 0412345678)' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'Contact', @level2type=N'COLUMN',@level2name=N'Detail'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'Contact', N'COLUMN',N'ContactMethodId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies the contact method.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'Contact', @level2type=N'COLUMN',@level2name=N'ContactMethodId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'Contact', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'An electronic contact number or address for a single patient or hospital. Records must never be shared between patients.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'Contact'
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_Contact_ContactMethod]') AND parent_object_id = OBJECT_ID(N'[hips].[Contact]'))
ALTER TABLE [hips].[Contact]  WITH CHECK ADD  CONSTRAINT [FK_Contact_ContactMethod] FOREIGN KEY([ContactMethodId])
REFERENCES [hips].[ContactMethod] ([ContactMethodId])
ON DELETE CASCADE
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_Contact_ContactMethod]') AND parent_object_id = OBJECT_ID(N'[hips].[Contact]'))
ALTER TABLE [hips].[Contact] CHECK CONSTRAINT [FK_Contact_ContactMethod]
GO

