SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[ContactMethod]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[ContactMethod](
	[ContactMethodId] [int] IDENTITY(1,1) NOT NULL,
	[TelecommunicationType] [varchar](10) NOT NULL,
	[CdaType] [varchar](10) NOT NULL,
	[Description] [varchar](40) NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_ContactMethod] PRIMARY KEY CLUSTERED 
(
	[ContactMethodId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'ContactMethod', N'COLUMN',N'ContactMethodId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies an electronic contact method' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'ContactMethod', @level2type=N'COLUMN',@level2name=N'ContactMethodId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'ContactMethod', N'COLUMN',N'TelecommunicationType'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'HL7 v3 TelecommunicationAddressType (e.g. H, MC, PG, WP)
' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'ContactMethod', @level2type=N'COLUMN',@level2name=N'TelecommunicationType'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'ContactMethod', N'COLUMN',N'CdaType'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'HL7 v3 URLScheme (e.g. tel, fax, mailto)' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'ContactMethod', @level2type=N'COLUMN',@level2name=N'CdaType'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'ContactMethod', N'COLUMN',N'Description'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Description (e.g. Home Phone, Home Fax, Personal Mobile, Personal Email, Pager, Work Phone, Work Fax, Work Mobile, Work Email)' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'ContactMethod', @level2type=N'COLUMN',@level2name=N'Description'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'ContactMethod', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies an electronic contact method' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'ContactMethod'
GO

