SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[DisclosureAudit]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[DisclosureAudit](
	[DisclosureAuditId] [int] IDENTITY(1,1) NOT NULL,
	[HealthProviderOrganisationId] [int] NOT NULL,
	[PatientMasterId] [int] NOT NULL,
	[PcehrDisclosed] [bit] NOT NULL,
	[AuditInformation] [varbinary](MAX),
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_DisclosureAudit] PRIMARY KEY CLUSTERED 
(
	[DisclosureAuditId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'DisclosureAudit', N'COLUMN',N'DisclosureAuditId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Primary Key' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'DisclosureAudit', @level2type=N'COLUMN',@level2name=N'DisclosureAuditId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'DisclosureAudit', N'COLUMN',N'HealthProviderOrganisationId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Link to the HPI-O for which disclosure was modified' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'DisclosureAudit', @level2type=N'COLUMN',@level2name=N'HealthProviderOrganisationId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'DisclosureAudit', N'COLUMN',N'PatientMasterId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Link to the patient for which consent was modified' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'DisclosureAudit', @level2type=N'COLUMN',@level2name=N'PatientMasterId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'DisclosureAudit', N'COLUMN',N'PcehrDisclosed'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'New value of the PCEHR disclosed flag' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'DisclosureAudit', @level2type=N'COLUMN',@level2name=N'PcehrDisclosed'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'DisclosureAudit', N'COLUMN',N'AuditInformation'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Hold the form data for posterity' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'DisclosureAudit', @level2type=N'COLUMN',@level2name=N'AuditInformation'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'DisclosureAudit', N'COLUMN',N'DateCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date that this record was inserted into the table' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'DisclosureAudit', @level2type=N'COLUMN',@level2name=N'DateCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'DisclosureAudit', N'COLUMN',N'UserCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User account that inserted the record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'DisclosureAudit', @level2type=N'COLUMN',@level2name=N'UserCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'DisclosureAudit', N'COLUMN',N'DateModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date and time that this record was last modified (or as inserted)' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'DisclosureAudit', @level2type=N'COLUMN',@level2name=N'DateModified'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'DisclosureAudit', N'COLUMN',N'UserModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The account of the user that last modified (or inserted) this record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'DisclosureAudit', @level2type=N'COLUMN',@level2name=N'UserModified'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'DisclosureAudit', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Record that a user made a change to the patient''s disclosure of a PCEHR to a particular health provider organisation.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'DisclosureAudit'
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_DisclosureAudit_HealthProviderOrganisation]') AND parent_object_id = OBJECT_ID(N'[hips].[DisclosureAudit]'))
ALTER TABLE [hips].[DisclosureAudit]  WITH CHECK ADD  CONSTRAINT [FK_DisclosureAudit_HealthProviderOrganisation] FOREIGN KEY([HealthProviderOrganisationId])
REFERENCES [hips].[HealthProviderOrganisation] ([HealthProviderOrganisationId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_DisclosureAudit_HealthProviderOrganisation]') AND parent_object_id = OBJECT_ID(N'[hips].[DisclosureAudit]'))
ALTER TABLE [hips].[DisclosureAudit] CHECK CONSTRAINT [FK_DisclosureAudit_HealthProviderOrganisation]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_DisclosureAudit_PatientMaster]') AND parent_object_id = OBJECT_ID(N'[hips].[DisclosureAudit]'))
ALTER TABLE [hips].[DisclosureAudit]  WITH CHECK ADD  CONSTRAINT [FK_DisclosureAudit_PatientMaster] FOREIGN KEY([PatientMasterId])
REFERENCES [hips].[PatientMaster] ([PatientMasterId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_DisclosureAudit_PatientMaster]') AND parent_object_id = OBJECT_ID(N'[hips].[DisclosureAudit]'))
ALTER TABLE [hips].[DisclosureAudit] CHECK CONSTRAINT [FK_DisclosureAudit_PatientMaster]
GO

