SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[DocumentFormat]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[DocumentFormat](
	[DocumentFormatId] [int] IDENTITY(1,1) NOT NULL,
	[Code] [varchar](100) NOT NULL,
	[Description] [varchar](200) NOT NULL,
	[CodeSystemId] [int] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_DocumentFormat] PRIMARY KEY CLUSTERED 
(
	[DocumentFormatId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO

IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'DocumentFormat', N'COLUMN',N'Code'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Code (e.g. 1.2.36.1.2001.1006.1.20000.11)' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'DocumentFormat', @level2type=N'COLUMN',@level2name=N'Code'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'DocumentFormat', N'COLUMN',N'Description'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Description (e.g. Discharge Summary - Conformance 3A)' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'DocumentFormat', @level2type=N'COLUMN',@level2name=N'Description'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'DocumentFormat', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies a format of clinical document (type and conformance level)' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'DocumentFormat'
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_DocumentFormat_CodeSystem]') AND parent_object_id = OBJECT_ID(N'[hips].[DocumentFormat]'))
ALTER TABLE [hips].[DocumentFormat]  WITH CHECK ADD  CONSTRAINT [FK_DocumentFormat_CodeSystem] FOREIGN KEY([CodeSystemId])
REFERENCES [hips].[CodeSystem] ([CodeSystemId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_DocumentFormat_CodeSystem]') AND parent_object_id = OBJECT_ID(N'[hips].[DocumentFormat]'))
ALTER TABLE [hips].[DocumentFormat] CHECK CONSTRAINT [FK_DocumentFormat_CodeSystem]
GO

