SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[DownloadedDocument]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[DownloadedDocument](
	[DownloadedDocumentId] [int] IDENTITY(1,1) NOT NULL,
	[PatientMasterId] [int] NOT NULL,
	[SourceSystemDocumentId] [varchar](256) NOT NULL,
	[Package] [varbinary](max) NULL,
	[DownloadedDate] [datetime] NOT NULL,
	[ClinicalDocumentStatusId] [int] NOT NULL,
	[CurrentDocumentId] [int] NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_DownloadedDocument] PRIMARY KEY CLUSTERED 
(
	[DownloadedDocumentId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'DownloadedDocument', N'COLUMN',N'DownloadedDocumentId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies a downloaded document instance' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'DownloadedDocument', @level2type=N'COLUMN',@level2name=N'DownloadedDocumentId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'DownloadedDocument', N'COLUMN',N'PatientMasterId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The patient that this document relates to' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'DownloadedDocument', @level2type=N'COLUMN',@level2name=N'PatientMasterId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'DownloadedDocument', N'COLUMN',N'SourceSystemDocumentId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A globally-unique identifier for this document instance. Can be a UUID or an OID, or an OID^extension.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'DownloadedDocument', @level2type=N'COLUMN',@level2name=N'SourceSystemDocumentId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'DownloadedDocument', N'COLUMN',N'Package'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The CDA package is stored here if the clinical system requests.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'DownloadedDocument', @level2type=N'COLUMN',@level2name=N'Package'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'DownloadedDocument', N'COLUMN',N'DownloadedDate'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The date and time when this version was downloaded.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'DownloadedDocument', @level2type=N'COLUMN',@level2name=N'DownloadedDate'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'DownloadedDocument', N'COLUMN',N'ClinicalDocumentStatusId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Initially ''downloaded'', later may be ''superseded'' or ''removed''.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'DownloadedDocument', @level2type=N'COLUMN',@level2name=N'ClinicalDocumentStatusId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'DownloadedDocument', N'COLUMN',N'CurrentDocumentId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Link within this table to the most recent version of this document' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'DownloadedDocument', @level2type=N'COLUMN',@level2name=N'CurrentDocumentId'
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_DownloadedDocument_ClinicalDocumentStatus]') AND parent_object_id = OBJECT_ID(N'[hips].[DownloadedDocument]'))
ALTER TABLE [hips].[DownloadedDocument]  WITH CHECK ADD  CONSTRAINT [FK_DownloadedDocument_ClinicalDocumentStatus] FOREIGN KEY([ClinicalDocumentStatusId])
REFERENCES [hips].[ClinicalDocumentStatus] ([ClinicalDocumentStatusId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_DownloadedDocument_ClinicalDocumentStatus]') AND parent_object_id = OBJECT_ID(N'[hips].[DownloadedDocument]'))
ALTER TABLE [hips].[DownloadedDocument] CHECK CONSTRAINT [FK_DownloadedDocument_ClinicalDocumentStatus]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_DownloadedDocument_DownloadedDocument]') AND parent_object_id = OBJECT_ID(N'[hips].[DownloadedDocument]'))
ALTER TABLE [hips].[DownloadedDocument]  WITH CHECK ADD  CONSTRAINT [FK_DownloadedDocument_DownloadedDocument] FOREIGN KEY([CurrentDocumentId])
REFERENCES [hips].[DownloadedDocument] ([DownloadedDocumentId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_DownloadedDocument_DownloadedDocument]') AND parent_object_id = OBJECT_ID(N'[hips].[DownloadedDocument]'))
ALTER TABLE [hips].[DownloadedDocument] CHECK CONSTRAINT [FK_DownloadedDocument_DownloadedDocument]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_DownloadedDocument_PatientMaster]') AND parent_object_id = OBJECT_ID(N'[hips].[DownloadedDocument]'))
ALTER TABLE [hips].[DownloadedDocument]  WITH CHECK ADD  CONSTRAINT [FK_DownloadedDocument_PatientMaster] FOREIGN KEY([PatientMasterId])
REFERENCES [hips].[PatientMaster] ([PatientMasterId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_DownloadedDocument_PatientMaster]') AND parent_object_id = OBJECT_ID(N'[hips].[DownloadedDocument]'))
ALTER TABLE [hips].[DownloadedDocument] CHECK CONSTRAINT [FK_DownloadedDocument_PatientMaster]
GO

