SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[Episode]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[Episode](
	[EpisodeId] [int] IDENTITY(1,1) NOT NULL,
	[PatientId] [int] NOT NULL,
	[SourceSystemEpisodeId] [varchar](100) NOT NULL,
	[AdmissionDate] [datetime] NOT NULL,
	[AdmissionReason] [varchar](1000) NULL,
	[DischargeDate] [datetime] NULL,
	[ResponsibleProviderId] [int] NOT NULL,
	[EpisodeTypeId] [int] NULL,
	[EpisodeLifecycleId] [int] NULL,
	[ConsentWithdrawn] [bit] NOT NULL,
	[Ward] [varchar](40) NULL,
	[Room] [varchar](40) NULL,
	[Bed] [varchar](40) NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_Episode] PRIMARY KEY CLUSTERED 
(
	[EpisodeId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'Episode', N'COLUMN',N'PatientId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The patient record at the specific hospital in which this episode is situated.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'Episode', @level2type=N'COLUMN',@level2name=N'PatientId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'Episode', N'COLUMN',N'SourceSystemEpisodeId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifier for this episode allocated by the PAS' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'Episode', @level2type=N'COLUMN',@level2name=N'SourceSystemEpisodeId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'Episode', N'COLUMN',N'AdmissionDate'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Admission / service start date and time
' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'Episode', @level2type=N'COLUMN',@level2name=N'AdmissionDate'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'Episode', N'COLUMN',N'AdmissionReason'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Overall reason why the patient is in hospital.
' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'Episode', @level2type=N'COLUMN',@level2name=N'AdmissionReason'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'Episode', N'COLUMN',N'DischargeDate'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Discharge / service stop date and time' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'Episode', @level2type=N'COLUMN',@level2name=N'DischargeDate'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'Episode', N'COLUMN',N'ResponsibleProviderId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Responsible provider for this episode, as supplied by the PAS' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'Episode', @level2type=N'COLUMN',@level2name=N'ResponsibleProviderId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'Episode', N'COLUMN',N'EpisodeTypeId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Type of episode (e.g. inpatient admission, day admission, outpatient visit, emergency visit).' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'Episode', @level2type=N'COLUMN',@level2name=N'EpisodeTypeId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'Episode', N'COLUMN',N'EpisodeLifecycleId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The current stage of this episode (e.g. future booking, in progress, ended, cancelled).' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'Episode', @level2type=N'COLUMN',@level2name=N'EpisodeLifecycleId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'Episode', N'COLUMN',N'ConsentWithdrawn'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Stores the patient''s withdrawal of consent to upload documents relating to this episode to his/her PCEHR. When 0 it represents the default state where uploading will proceed. When 1 then consent is withdrawn and HIPS must prevent the upload.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'Episode', @level2type=N'COLUMN',@level2name=N'ConsentWithdrawn'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'Episode', N'COLUMN',N'Ward'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Ward component of patient location' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'Episode', @level2type=N'COLUMN',@level2name=N'Ward'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'Episode', N'COLUMN',N'Room'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Room component of patient location' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'Episode', @level2type=N'COLUMN',@level2name=N'Room'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'Episode', N'COLUMN',N'Bed'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Bed component of patient location' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'Episode', @level2type=N'COLUMN',@level2name=N'Bed'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'Episode', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'An admission or other visit by a patient to a hospital.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'Episode'
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_Episode_EpisodeLifecycle]') AND parent_object_id = OBJECT_ID(N'[hips].[Episode]'))
ALTER TABLE [hips].[Episode]  WITH CHECK ADD  CONSTRAINT [FK_Episode_EpisodeLifecycle] FOREIGN KEY([EpisodeLifecycleId])
REFERENCES [hips].[EpisodeLifecycle] ([EpisodeLifecycleId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_Episode_EpisodeLifecycle]') AND parent_object_id = OBJECT_ID(N'[hips].[Episode]'))
ALTER TABLE [hips].[Episode] CHECK CONSTRAINT [FK_Episode_EpisodeLifecycle]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_Episode_EpisodeType]') AND parent_object_id = OBJECT_ID(N'[hips].[Episode]'))
ALTER TABLE [hips].[Episode]  WITH CHECK ADD  CONSTRAINT [FK_Episode_EpisodeType] FOREIGN KEY([EpisodeTypeId])
REFERENCES [hips].[EpisodeType] ([EpisodeTypeId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_Episode_EpisodeType]') AND parent_object_id = OBJECT_ID(N'[hips].[Episode]'))
ALTER TABLE [hips].[Episode] CHECK CONSTRAINT [FK_Episode_EpisodeType]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_Episode_HealthProviderIndividual]') AND parent_object_id = OBJECT_ID(N'[hips].[Episode]'))
ALTER TABLE [hips].[Episode]  WITH CHECK ADD  CONSTRAINT [FK_Episode_HealthProviderIndividual] FOREIGN KEY([ResponsibleProviderId])
REFERENCES [hips].[HealthProviderIndividual] ([HealthProviderIndividualId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_Episode_HealthProviderIndividual]') AND parent_object_id = OBJECT_ID(N'[hips].[Episode]'))
ALTER TABLE [hips].[Episode] CHECK CONSTRAINT [FK_Episode_HealthProviderIndividual]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_Episode_Patient]') AND parent_object_id = OBJECT_ID(N'[hips].[Episode]'))
ALTER TABLE [hips].[Episode]  WITH CHECK ADD  CONSTRAINT [FK_Episode_Patient] FOREIGN KEY([PatientId])
REFERENCES [hips].[HospitalPatient] ([PatientId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_Episode_Patient]') AND parent_object_id = OBJECT_ID(N'[hips].[Episode]'))
ALTER TABLE [hips].[Episode] CHECK CONSTRAINT [FK_Episode_Patient]
GO

