SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[HL7MessageLog]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[HL7MessageLog](
	[HL7MessageLogId] [int] IDENTITY(1,1) NOT NULL,
	[HospitalId] [int] NULL,
	[HospitalPatientIdentifier] [varchar](20) NULL,
	[SendingApplication] [varchar](180) NULL,
	[SendingFacility] [varchar](180) NULL,
	[MessageControlId] [varchar](25) NULL,
	[DateTimeOfMessage] [datetime] NULL,
	[ShouldRetry] [bit] NOT NULL,
	[RetryCount] [int] NOT NULL,
	[FailureReason] [varchar](256) NULL,
	[QueueStatusId] [int] NOT NULL,
	[FullMessage] [varchar](max) NOT NULL,	
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_HL7MessageLog] PRIMARY KEY CLUSTERED 
(
	[HL7MessageLogId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HL7MessageLog_Hospital]') AND parent_object_id = OBJECT_ID(N'[hips].[HL7MessageLog]'))
ALTER TABLE [hips].[HL7MessageLog]  WITH CHECK ADD  CONSTRAINT [FK_HL7MessageLog_Hospital] FOREIGN KEY([HospitalId])
REFERENCES [hips].[Hospital] ([HospitalId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HL7MessageLog_Hospital]') AND parent_object_id = OBJECT_ID(N'[hips].[HL7MessageLog]'))
ALTER TABLE [hips].[HL7MessageLog] CHECK CONSTRAINT [FK_HL7MessageLog_Hospital]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HL7MessageLog_QueueStatus]') AND parent_object_id = OBJECT_ID(N'[hips].[HL7MessageLog]'))
ALTER TABLE [hips].[HL7MessageLog]  WITH CHECK ADD  CONSTRAINT [FK_HL7MessageLog_QueueStatus] FOREIGN KEY([QueueStatusId])
REFERENCES [hips].[QueueStatus] ([QueueStatusId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HL7MessageLog_QueueStatus]') AND parent_object_id = OBJECT_ID(N'[hips].[HL7MessageLog]'))
ALTER TABLE [hips].[HL7MessageLog] CHECK CONSTRAINT [FK_HL7MessageLog_QueueStatus]
GO

