SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[HealthProviderIndividual]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[HealthProviderIndividual](
	[HealthProviderIndividualId] [int] IDENTITY(1,1) NOT NULL,
	[IamProviderIdentifier] [varchar](30) NULL,
	[HpiI] [varchar](16) NULL,
	[HpiILastValidatedDate] [datetime] NULL,
	[TitleId] [int] NOT NULL,
	[FamilyName] [varchar](80) NOT NULL,
	[GivenNames] [varchar](100) NULL,
	[SuffixId] [int] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_Provider] PRIMARY KEY CLUSTERED 
(
	[HealthProviderIndividualId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HealthProviderIndividual', N'COLUMN',N'IamProviderIdentifier'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifier of this provider allocated by the jurisdiction''s Identity and Access Management (IAM) system (e.g. Health Active Directory account)' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HealthProviderIndividual', @level2type=N'COLUMN',@level2name=N'IamProviderIdentifier'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HealthProviderIndividual', N'COLUMN',N'HpiI'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'HPI-I of this provider' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HealthProviderIndividual', @level2type=N'COLUMN',@level2name=N'HpiI'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HealthProviderIndividual', N'COLUMN',N'HpiILastValidatedDate'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date and time when the HPI-I was last validated' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HealthProviderIndividual', @level2type=N'COLUMN',@level2name=N'HpiILastValidatedDate'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HealthProviderIndividual', N'COLUMN',N'TitleId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Name title' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HealthProviderIndividual', @level2type=N'COLUMN',@level2name=N'TitleId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HealthProviderIndividual', N'COLUMN',N'FamilyName'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Family name with which the HPI-I was validated' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HealthProviderIndividual', @level2type=N'COLUMN',@level2name=N'FamilyName'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HealthProviderIndividual', N'COLUMN',N'GivenNames'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Given names with which the HPI-I was validated' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HealthProviderIndividual', @level2type=N'COLUMN',@level2name=N'GivenNames'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HealthProviderIndividual', N'COLUMN',N'SuffixId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Name suffix' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HealthProviderIndividual', @level2type=N'COLUMN',@level2name=N'SuffixId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HealthProviderIndividual', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies an individual healthcare provider who works at one or more of the hospital facilities within the jurisdiction, who is suitable to be identified as a Document Author or Responsible Health Professional at Time of Discharge.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HealthProviderIndividual'
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HealthProviderIndividual_Suffix]') AND parent_object_id = OBJECT_ID(N'[hips].[HealthProviderIndividual]'))
ALTER TABLE [hips].[HealthProviderIndividual]  WITH CHECK ADD  CONSTRAINT [FK_HealthProviderIndividual_Suffix] FOREIGN KEY([SuffixId])
REFERENCES [hips].[Suffix] ([SuffixId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HealthProviderIndividual_Suffix]') AND parent_object_id = OBJECT_ID(N'[hips].[HealthProviderIndividual]'))
ALTER TABLE [hips].[HealthProviderIndividual] CHECK CONSTRAINT [FK_HealthProviderIndividual_Suffix]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HealthProviderIndividual_Title]') AND parent_object_id = OBJECT_ID(N'[hips].[HealthProviderIndividual]'))
ALTER TABLE [hips].[HealthProviderIndividual]  WITH CHECK ADD  CONSTRAINT [FK_HealthProviderIndividual_Title] FOREIGN KEY([TitleId])
REFERENCES [hips].[Title] ([TitleId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HealthProviderIndividual_Title]') AND parent_object_id = OBJECT_ID(N'[hips].[HealthProviderIndividual]'))
ALTER TABLE [hips].[HealthProviderIndividual] CHECK CONSTRAINT [FK_HealthProviderIndividual_Title]
GO

