SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[HealthProviderOrganisation]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[HealthProviderOrganisation](
	[HealthProviderOrganisationId] [int] IDENTITY(1,1) NOT NULL,
	[HpiO] [varchar](16) NOT NULL,
	[Name] [varchar](100) NOT NULL,
	[HiCertSerial] [varchar](32) NOT NULL,
	[PcehrCertSerial] [varchar](32) NOT NULL,
	[AuthorisedEmployeeName] [varchar](100) NULL,
	[AuthorisedEmployeeUserId] [varchar](30) NULL,
	[VisitorHospitalId] [int] NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_HealthProviderOrganisation] PRIMARY KEY CLUSTERED 
(
	[HealthProviderOrganisationId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HealthProviderOrganisation', N'COLUMN',N'HealthProviderOrganisationId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Represents an organisation in the HPI-O network structure.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HealthProviderOrganisation', @level2type=N'COLUMN',@level2name=N'HealthProviderOrganisationId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HealthProviderOrganisation', N'COLUMN',N'HpiO'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'National identifier for health provider organisation.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HealthProviderOrganisation', @level2type=N'COLUMN',@level2name=N'HpiO'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HealthProviderOrganisation', N'COLUMN',N'Name'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Name of the organisation.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HealthProviderOrganisation', @level2type=N'COLUMN',@level2name=N'Name'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HealthProviderOrganisation', N'COLUMN',N'HiCertSerial'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Hexadecimal serial number for certificate used to establish connections to Healthcare Identifier Service.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HealthProviderOrganisation', @level2type=N'COLUMN',@level2name=N'HiCertSerial'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HealthProviderOrganisation', N'COLUMN',N'PcehrCertSerial'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Hexadecimal serial number for certificate used to establish connections to PCEHR B2B Gateway Service.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HealthProviderOrganisation', @level2type=N'COLUMN',@level2name=N'PcehrCertSerial'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HealthProviderOrganisation', N'COLUMN',N'AuthorisedEmployeeUserId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Name of the Authorised Employee for this HPIO.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HealthProviderOrganisation', @level2type=N'COLUMN',@level2name=N'AuthorisedEmployeeUserId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HealthProviderOrganisation', N'COLUMN',N'AuthorisedEmployeeName'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User Name of the Authorised Employee for this HPIO.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HealthProviderOrganisation', @level2type=N'COLUMN',@level2name=N'AuthorisedEmployeeName'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HealthProviderOrganisation', N'COLUMN',N'VisitorHospitalId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Hospital Id related to the visitor hospital.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HealthProviderOrganisation', @level2type=N'COLUMN',@level2name=N'VisitorHospitalId'
GO

