SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[HealthProviderOrganisationPatient]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[HealthProviderOrganisationPatient](
	[HealthProviderOrganisationId] [int] NOT NULL,
	[PatientMasterId] [int] NOT NULL,
	[PcehrAdvertised] [bit] NULL,
	[AccessCodeRequiredId] [int] NOT NULL,
	[PcehrDisclosed] [bit] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_HealthProviderOrganisationPatient] PRIMARY KEY CLUSTERED 
(
	[HealthProviderOrganisationId] ASC,
	[PatientMasterId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HealthProviderOrganisationPatient', N'COLUMN',N'HealthProviderOrganisationId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Link to the Health Provider Organisation (HPI-O).' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HealthProviderOrganisationPatient', @level2type=N'COLUMN',@level2name=N'HealthProviderOrganisationId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HealthProviderOrganisationPatient', N'COLUMN',N'PatientMasterId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Link to the HIPS Patient Master record.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HealthProviderOrganisationPatient', @level2type=N'COLUMN',@level2name=N'PatientMasterId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HealthProviderOrganisationPatient', N'COLUMN',N'PcehrAdvertised'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Whether the patient has chosen to advertise the existence of his/her PCEHR to this HPO.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HealthProviderOrganisationPatient', @level2type=N'COLUMN',@level2name=N'PcehrAdvertised'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HealthProviderOrganisationPatient', N'COLUMN',N'AccessCodeRequiredId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Whether access has been gained, and whether a code will be required to gain access.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HealthProviderOrganisationPatient', @level2type=N'COLUMN',@level2name=N'AccessCodeRequiredId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HealthProviderOrganisationPatient', N'COLUMN',N'PcehrDisclosed'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Whether the patient has disclosed the existence of his/her PCEHR to this HPO.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HealthProviderOrganisationPatient', @level2type=N'COLUMN',@level2name=N'PcehrDisclosed'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HealthProviderOrganisationPatient', N'COLUMN',N'DateCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date that this patient record was inserted into the table' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HealthProviderOrganisationPatient', @level2type=N'COLUMN',@level2name=N'DateCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HealthProviderOrganisationPatient', N'COLUMN',N'UserCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User account that inserted the record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HealthProviderOrganisationPatient', @level2type=N'COLUMN',@level2name=N'UserCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HealthProviderOrganisationPatient', N'COLUMN',N'DateModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date and time that this record was last modified (or as inserted)' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HealthProviderOrganisationPatient', @level2type=N'COLUMN',@level2name=N'DateModified'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HealthProviderOrganisationPatient', N'COLUMN',N'UserModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The account of the user that last modified (or inserted) this record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HealthProviderOrganisationPatient', @level2type=N'COLUMN',@level2name=N'UserModified'
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HealthProviderOrganisationPatient_AccessCodeRequired]') AND parent_object_id = OBJECT_ID(N'[hips].[HealthProviderOrganisationPatient]'))
ALTER TABLE [hips].[HealthProviderOrganisationPatient]  WITH CHECK ADD  CONSTRAINT [FK_HealthProviderOrganisationPatient_AccessCodeRequired] FOREIGN KEY([AccessCodeRequiredId])
REFERENCES [hips].[AccessCodeRequired] ([AccessCodeRequiredId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HealthProviderOrganisationPatient_AccessCodeRequired]') AND parent_object_id = OBJECT_ID(N'[hips].[HealthProviderOrganisationPatient]'))
ALTER TABLE [hips].[HealthProviderOrganisationPatient] CHECK CONSTRAINT [FK_HealthProviderOrganisationPatient_AccessCodeRequired]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HealthProviderOrganisationPatient_HealthProviderOrganisation]') AND parent_object_id = OBJECT_ID(N'[hips].[HealthProviderOrganisationPatient]'))
ALTER TABLE [hips].[HealthProviderOrganisationPatient]  WITH CHECK ADD  CONSTRAINT [FK_HealthProviderOrganisationPatient_HealthProviderOrganisation] FOREIGN KEY([HealthProviderOrganisationId])
REFERENCES [hips].[HealthProviderOrganisation] ([HealthProviderOrganisationId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HealthProviderOrganisationPatient_HealthProviderOrganisation]') AND parent_object_id = OBJECT_ID(N'[hips].[HealthProviderOrganisationPatient]'))
ALTER TABLE [hips].[HealthProviderOrganisationPatient] CHECK CONSTRAINT [FK_HealthProviderOrganisationPatient_HealthProviderOrganisation]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HealthProviderOrganisationPatient_PatientMaster]') AND parent_object_id = OBJECT_ID(N'[hips].[HealthProviderOrganisationPatient]'))
ALTER TABLE [hips].[HealthProviderOrganisationPatient]  WITH CHECK ADD  CONSTRAINT [FK_HealthProviderOrganisationPatient_PatientMaster] FOREIGN KEY([PatientMasterId])
REFERENCES [hips].[PatientMaster] ([PatientMasterId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HealthProviderOrganisationPatient_PatientMaster]') AND parent_object_id = OBJECT_ID(N'[hips].[HealthProviderOrganisationPatient]'))
ALTER TABLE [hips].[HealthProviderOrganisationPatient] CHECK CONSTRAINT [FK_HealthProviderOrganisationPatient_PatientMaster]
GO

