SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[Hospital]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[Hospital](
	[HospitalId] [int] IDENTITY(1,1) NOT NULL,
	[Description] [varchar](60) NOT NULL,
	[Name] [varchar](60) NULL,
	[HealthProviderOrganisationId] [int] NOT NULL,
	[AuthorisedEmployeeName] [varchar](100) NULL,
	[AuthorisedEmployeeUserId] [varchar](30) NULL,
	[Logo] [varbinary](max) NULL,
	[UploadDocumentMinimumAge] [int] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_Hospital] PRIMARY KEY CLUSTERED 
(
	[HospitalId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'Hospital', N'COLUMN',N'HospitalId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Represents a hospital facility within the jurisdiction.
' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'Hospital', @level2type=N'COLUMN',@level2name=N'HospitalId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'Hospital', N'COLUMN',N'Description'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A well-known description of the hospital (e.g. RAH or Noarlunga)
' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'Hospital', @level2type=N'COLUMN',@level2name=N'Description'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'Hospital', N'COLUMN',N'Name'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The full name of the hospital (e.g. Royal Adelaide Hospital)
' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'Hospital', @level2type=N'COLUMN',@level2name=N'Name'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'Hospital', N'COLUMN',N'HealthProviderOrganisationId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The HPI-O and related information that this hospital will use (depending on final HPI-O network structure).' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'Hospital', @level2type=N'COLUMN',@level2name=N'HealthProviderOrganisationId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'Hospital', N'COLUMN',N'AuthorisedEmployeeName'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Name of the authorised employee for actions triggered by automatic processes, such as IHI/HPII searching and PCEHR advertised checking.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'Hospital', @level2type=N'COLUMN',@level2name=N'AuthorisedEmployeeName'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'Hospital', N'COLUMN',N'AuthorisedEmployeeUserId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifier of the authorised employee for actions triggered by automatic processes, such as IHI/HPII searching and PCEHR advertised checking.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'Hospital', @level2type=N'COLUMN',@level2name=N'AuthorisedEmployeeUserId'
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_Hospital_HealthProviderOrganisation]') AND parent_object_id = OBJECT_ID(N'[hips].[Hospital]'))
ALTER TABLE [hips].[Hospital]  WITH CHECK ADD  CONSTRAINT [FK_Hospital_HealthProviderOrganisation] FOREIGN KEY([HealthProviderOrganisationId])
REFERENCES [hips].[HealthProviderOrganisation] ([HealthProviderOrganisationId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_Hospital_HealthProviderOrganisation]') AND parent_object_id = OBJECT_ID(N'[hips].[Hospital]'))
ALTER TABLE [hips].[Hospital] CHECK CONSTRAINT [FK_Hospital_HealthProviderOrganisation]
GO

