SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[HospitalAddress]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[HospitalAddress](
	[HospitalId] [int] NOT NULL,
	[AddressId] [int] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_HospitalAddress] PRIMARY KEY CLUSTERED 
(
	[HospitalId] ASC,
	[AddressId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HospitalAddress', N'COLUMN',N'HospitalId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Link to a hospital.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HospitalAddress', @level2type=N'COLUMN',@level2name=N'HospitalId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HospitalAddress', N'COLUMN',N'AddressId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Link to an address for this hospital.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HospitalAddress', @level2type=N'COLUMN',@level2name=N'AddressId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HospitalAddress', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Links a hospital to multiple physical addresses, such as the street address and postal address.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HospitalAddress'
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HospitalAddress_Address]') AND parent_object_id = OBJECT_ID(N'[hips].[HospitalAddress]'))
ALTER TABLE [hips].[HospitalAddress]  WITH CHECK ADD  CONSTRAINT [FK_HospitalAddress_Address] FOREIGN KEY([AddressId])
REFERENCES [hips].[Address] ([AddressId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HospitalAddress_Address]') AND parent_object_id = OBJECT_ID(N'[hips].[HospitalAddress]'))
ALTER TABLE [hips].[HospitalAddress] CHECK CONSTRAINT [FK_HospitalAddress_Address]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HospitalAddress_Hospital]') AND parent_object_id = OBJECT_ID(N'[hips].[HospitalAddress]'))
ALTER TABLE [hips].[HospitalAddress]  WITH CHECK ADD  CONSTRAINT [FK_HospitalAddress_Hospital] FOREIGN KEY([HospitalId])
REFERENCES [hips].[Hospital] ([HospitalId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HospitalAddress_Hospital]') AND parent_object_id = OBJECT_ID(N'[hips].[HospitalAddress]'))
ALTER TABLE [hips].[HospitalAddress] CHECK CONSTRAINT [FK_HospitalAddress_Hospital]
GO

