SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[HospitalCode]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[HospitalCode](
	[HospitalId] [int] NOT NULL,
	[CodeSystemId] [int] NOT NULL,
	[Code] [varchar](64) NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_HospitalCode] PRIMARY KEY CLUSTERED 
(
	[HospitalId] ASC,
	[CodeSystemId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HospitalCode', N'COLUMN',N'HospitalId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Hospital' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HospitalCode', @level2type=N'COLUMN',@level2name=N'HospitalId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HospitalCode', N'COLUMN',N'CodeSystemId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Type of identifier' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HospitalCode', @level2type=N'COLUMN',@level2name=N'CodeSystemId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HospitalCode', N'COLUMN',N'Code'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifier of the hospital' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HospitalCode', @level2type=N'COLUMN',@level2name=N'Code'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HospitalCode', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Links a hospital to multiple codes (identifiers), and a code to multiple hospitals. One of the codes that is linked is the HPI-O which may be shared between hospitals.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HospitalCode'
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HospitalCode_CodeSystem]') AND parent_object_id = OBJECT_ID(N'[hips].[HospitalCode]'))
ALTER TABLE [hips].[HospitalCode]  WITH CHECK ADD  CONSTRAINT [FK_HospitalCode_CodeSystem] FOREIGN KEY([CodeSystemId])
REFERENCES [hips].[CodeSystem] ([CodeSystemId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HospitalCode_CodeSystem]') AND parent_object_id = OBJECT_ID(N'[hips].[HospitalCode]'))
ALTER TABLE [hips].[HospitalCode] CHECK CONSTRAINT [FK_HospitalCode_CodeSystem]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HospitalCode_Hospital]') AND parent_object_id = OBJECT_ID(N'[hips].[HospitalCode]'))
ALTER TABLE [hips].[HospitalCode]  WITH CHECK ADD  CONSTRAINT [FK_HospitalCode_Hospital] FOREIGN KEY([HospitalId])
REFERENCES [hips].[Hospital] ([HospitalId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HospitalCode_Hospital]') AND parent_object_id = OBJECT_ID(N'[hips].[HospitalCode]'))
ALTER TABLE [hips].[HospitalCode] CHECK CONSTRAINT [FK_HospitalCode_Hospital]
GO

